import requests

__author__ = 'shillaker'


# Submits a vanilla HTTP GET request to Solr
def http_get(interface, request_string):
    base_url = 'http://%s:%s/solr/%s' % (interface.host, interface.port, interface.core)
    full_url = '%s%s' % (base_url, request_string)

    response = requests.get(full_url)

    # Error if request unsuccessful
    if response.status_code != 200:
        raise RuntimeError('Solr query to URL %s failed with status %d. Error message:\n%s' %
                           (full_url, response.status_code, response.content))

    return response


# Submits a vanilla HTTP requests to Solr
def http_get_json_response(interface, request_string):
    response = http_get(interface, request_string)

    # Decode JSON response
    response = response.json()

    return response


# Submits an XML request to Solr
def http_post_xml_request(interface, request_string, xml_content):

    base_url = 'http://%s:%s/solr/%s' % (interface.host, interface.port, interface.core)
    full_url = '%s%s' % (base_url, request_string)

    # Encode XML
    xml_content = xml_content.encode('utf-8')
    headers = {"Content-Type": "text/xml; charset=utf-8"}

    response = requests.post(full_url, headers=headers, data=xml_content)

    # Error if request unsuccessful
    if response.status_code != 200:
        raise RuntimeError('Solr XML request to URL %s failed with status %d. Error message:\n%s' %
                           (full_url, response.status_code, response.content))