from icarus.http.solr_http import http_get, http_post_xml_request
from icarus.query.query_classes import SearchQuery
from icarus.query.update_request_builder import build_commit_request, build_delete_all_request, build_add_request, \
    build_delete_by_ids_request

__author__ = 'shillaker'


# Interface for interacting with Solr
class IcarusInterface():

    # Constructor
    def __init__(self, host, port, core):
        self.host = host
        self.port = port
        self.core = core

    # Creates an empty select query
    def build_query(self):
        return SearchQuery(self)

    # Commits changes
    def commit(self):
        request_string = build_commit_request()
        http_get(self, request_string)

    # Deletes all documents in this core
    def delete_all(self, commit=False):
        request_string, xml_content = build_delete_all_request(commit=commit)
        http_post_xml_request(self, request_string, xml_content)

    # Adds a given document
    def add_doc(self, doc, commit=False):
        request_string, xml_content = build_add_request(doc, commit=commit)
        http_post_xml_request(self, request_string, xml_content)

    # Deletes documents by ID
    def delete_by_ids(self, doc_ids, commit=False):
        request_string, xml_content = build_delete_by_ids_request(doc_ids, commit=commit)
        http_post_xml_request(self, request_string, xml_content)


