#autogenerated by sqlautocode

from .extensions import db

gutenberg_books_category_map = db.Table(u'gutenberg_books_category_map', 
    db.Column(u'book_id', db.INTEGER(), db.ForeignKey('gutenberg_books.textId'), primary_key=True),
    db.Column(u'category_id', db.INTEGER(), db.ForeignKey('gutenberg_categories.id'), primary_key=True),
)

gutenberg_books_contributor_map = db.Table(u'gutenberg_books_contributor_map', 
    db.Column(u'book_id', db.INTEGER(), db.ForeignKey('gutenberg_books.textId'), primary_key=True),
    db.Column(u'contributor_id', db.INTEGER(), db.ForeignKey('gutenberg_contributors.id'), primary_key=True),
)

gutenberg_books_creator_map = db.Table(u'gutenberg_books_creator_map', 
    db.Column(u'book_id', db.INTEGER(), db.ForeignKey('gutenberg_books.textId'), primary_key=True),
    db.Column(u'creator_id', db.INTEGER(), db.ForeignKey('gutenberg_creators.id'), primary_key=True),
)

gutenberg_books_language_map = db.Table(u'gutenberg_books_language_map', 
    db.Column(u'book_id', db.INTEGER(), db.ForeignKey('gutenberg_books.textId'), primary_key=True),
    db.Column(u'language_id', db.INTEGER(), db.ForeignKey('gutenberg_languages.id'), primary_key=True),
)

gutenberg_books_subject_map = db.Table(u'gutenberg_books_subject_map', 
    db.Column(u'book_id', db.INTEGER(), db.ForeignKey('gutenberg_books.textId'), primary_key=True),
    db.Column(u'subject_id', db.INTEGER(), db.ForeignKey('gutenberg_subjects.id'), primary_key=True),
)

class GutenbergBook(db.Model):
    __tablename__ = 'gutenberg_books'

    __table_args__ = {}

    #column definitions
    downloads = db.Column(u'downloads', db.INTEGER())
    friendlytitle = db.Column(u'friendlytitle', db.TEXT())
    textId = db.Column(u'textId', db.TEXT(), primary_key=True, nullable=False)
    title = db.Column(u'title', db.TEXT())
    title_order = db.Column(u'title_order', db.INTEGER())

    #relation definitions
    gutenberg_categories = db.relation('GutenbergCategory', primaryjoin='GutenbergBook.textId==gutenberg_books_category_map.c.book_id', secondary=gutenberg_books_category_map, secondaryjoin='gutenberg_books_category_map.c.category_id==GutenbergCategory.id')
    gutenberg_contributors = db.relation('GutenbergContributor', primaryjoin='GutenbergBook.textId==gutenberg_books_contributor_map.c.book_id', secondary=gutenberg_books_contributor_map, secondaryjoin='gutenberg_books_contributor_map.c.contributor_id==GutenbergContributor.id')
    gutenberg_creators = db.relation('GutenbergCreator', primaryjoin='GutenbergBook.textId==gutenberg_books_creator_map.c.book_id', secondary=gutenberg_books_creator_map, secondaryjoin='gutenberg_books_creator_map.c.creator_id==GutenbergCreator.id')
    gutenberg_languages = db.relation('GutenbergLanguage', primaryjoin='GutenbergBook.textId==gutenberg_books_language_map.c.book_id', secondary=gutenberg_books_language_map, secondaryjoin='gutenberg_books_language_map.c.language_id==GutenbergLanguage.id')
    gutenberg_subjects = db.relation('GutenbergSubject', primaryjoin='GutenbergBook.textId==gutenberg_books_subject_map.c.book_id', secondary=gutenberg_books_subject_map, secondaryjoin='gutenberg_books_subject_map.c.subject_id==GutenbergSubject.id')
    gutenberg_files = db.relation('GutenbergFile')


class GutenbergCategory(db.Model):
    __tablename__ = 'gutenberg_categories'

    __table_args__ = {}

    #column definitions
    category = db.Column(u'category', db.TEXT())
    id = db.Column(u'id', db.INTEGER(), primary_key=True, nullable=False)

    #relation definitions
    gutenberg_books = db.relation('GutenbergBook', primaryjoin='GutenbergCategory.id==gutenberg_books_category_map.c.category_id', secondary=gutenberg_books_category_map, secondaryjoin='gutenberg_books_category_map.c.book_id==GutenbergBook.textId')


class GutenbergContributor(db.Model):
    __tablename__ = 'gutenberg_contributors'

    __table_args__ = {}

    #column definitions
    contributor = db.Column(u'contributor', db.TEXT())
    downloads = db.Column(u'downloads', db.INTEGER())
    id = db.Column(u'id', db.INTEGER(), primary_key=True, nullable=False)

    #relation definitions
    gutenberg_books = db.relation('GutenbergBook', primaryjoin='GutenbergContributor.id==gutenberg_books_contributor_map.c.contributor_id', secondary=gutenberg_books_contributor_map, secondaryjoin='gutenberg_books_contributor_map.c.book_id==GutenbergBook.textId')


class GutenbergCreator(db.Model):
    __tablename__ = 'gutenberg_creators'

    __table_args__ = {}

    #column definitions
    creator = db.Column(u'creator', db.TEXT())
    downloads = db.Column(u'downloads', db.INTEGER())
    id = db.Column(u'id', db.INTEGER(), primary_key=True, nullable=False)

    #relation definitions
    gutenberg_books = db.relation('GutenbergBook', primaryjoin='GutenbergCreator.id==gutenberg_books_creator_map.c.creator_id', secondary=gutenberg_books_creator_map, secondaryjoin='gutenberg_books_creator_map.c.book_id==GutenbergBook.textId')


class GutenbergFile(db.Model):
    __tablename__ = 'gutenberg_files'

    __table_args__ = {}

    #column definitions
    file = db.Column(u'file', db.TEXT())
    format = db.Column(u'format', db.TEXT())
    id = db.Column(u'id', db.INTEGER(), primary_key=True, nullable=False)
    textId = db.Column(u'textId', db.TEXT(), db.ForeignKey('gutenberg_books.textId'))

    #relation definitions
    gutenberg_books = db.relation('GutenbergBook', primaryjoin='GutenbergFile.textId==GutenbergBook.textId')


class GutenbergLanguage(db.Model):
    __tablename__ = 'gutenberg_languages'

    __table_args__ = {}

    #column definitions
    id = db.Column(u'id', db.INTEGER(), primary_key=True, nullable=False)
    language = db.Column(u'language', db.TEXT())

    #relation definitions
    gutenberg_books = db.relation('GutenbergBook', primaryjoin='GutenbergLanguage.id==gutenberg_books_language_map.c.language_id', secondary=gutenberg_books_language_map, secondaryjoin='gutenberg_books_language_map.c.book_id==GutenbergBook.textId')


class GutenbergSubject(db.Model):
    __tablename__ = 'gutenberg_subjects'

    __table_args__ = {}

    #column definitions
    id = db.Column(u'id', db.INTEGER(), primary_key=True, nullable=False)
    subject = db.Column(u'subject', db.TEXT())

    #relation definitions
    gutenberg_books = db.relation('GutenbergBook', primaryjoin='GutenbergSubject.id==gutenberg_books_subject_map.c.subject_id', secondary=gutenberg_books_subject_map, secondaryjoin='gutenberg_books_subject_map.c.book_id==GutenbergBook.textId')


