# -*- coding: utf-8 -*-

"""
I/O utilities

:copyright: Copyright (C) 2013 Gianluca Costa.
:license: LGPLv3, see LICENSE for details.
"""

from __future__ import unicode_literals

import os

class PathOperations(object):
	"""
	Encapsulates operations on paths
	"""


	@staticmethod
	def safeMakeDirs(path, mode=0777):
		"""
		Creates the given directory path, as well as intermediate directories.
		Catches any I/O exception, returning False in that case; otherwise,
		True is returned.
		"""
		try:
			os.makedirs(path, mode)
			
			return True
		except (IOError, OSError):
			return False
		
		
	@staticmethod
	def safeRemove(path):
		"""
		Removes the given file, returning true if the 
		operation was successful.
		
		Any I/O exception is caught.
		"""
		try:
			os.remove(path)
			return True
		except (IOError, OSError):
			return False
		
		
	@staticmethod
	def touch(path):
		"""
		Creates the given path as a file, also creating 
		intermediate directories if required.
		"""
		
		parentDirPath = os.path.dirname(path)

		PathOperations.safeMakeDirs(parentDirPath)

		with open(path, "wb"):
			pass