# -*- coding: utf-8 -*-

"""
:copyright: Copyright (C) 2013 Gianluca Costa.
:license: LGPLv3, see LICENSE for details.
"""

#
# NOTE: for testing, string literals in this module 
# are "str" objects by default! Not Unicode!
#

import unittest

from ..strings import String


class StringsTests(unittest.TestCase):
	def testIsStringShouldWorkWithStrLiteral(self):
		self.assertTrue(String.isString("Test"))
		
		
	def testIsStringShouldWorkWithUnicodeLiteral(self):
		self.assertTrue(String.isString(u"Test"))
		
		
	def testStringShouldReturnAUnicodeFromAStrInstance(self):
		testString = String("Test")
		
		self.assertIsInstance(testString, unicode)
		
		
	def testStringShouldReturnAUnicodeFromAUnicodeInstance(self):
		testString = String(u"Test")
		
		self.assertIsInstance(testString, unicode)
		
	
	def testStringShouldWorkAUnicodeFromAStrHavingAccents(self):
		testString = String("Voilà un example intéressant")
		
		self.assertIsInstance(testString, unicode)
		
	
	def testStringShouldWorkAUnicodeFromAUnicodeHavingAccents(self):
		testString = String(u"Voilà un example intéressant")
		
		self.assertIsInstance(testString, unicode)
		
		
	def testStringShouldReturnAUnicodeFromAnIntInstance(self):
		testString = String(90)
				
		self.assertIsInstance(testString, unicode)