# -*- coding: utf-8 -*-

"""
:copyright: Copyright (C) 2013 Gianluca Costa.
:license: LGPLv3, see LICENSE for details.
"""


from __future__ import unicode_literals

import os

from ..vars import VariablesService, Flag
from ..io import PathOperations

from .tests_kernel import AbstractSiteTestCase


class VariablesTestCase(AbstractSiteTestCase):
	def setUp(self):
		super(VariablesTestCase, self).setUp()

		self._varsDir = os.path.join(self._siteDirPath, "_vars")
		self._variablesService = VariablesService(self._varsDir)


class VariablesServiceTests(VariablesTestCase):
	def testGetFlagShouldReturnAFlagHavingTheRightPath(self):
		flag = self._variablesService.getFlag("myTestFlag")
		self.assertEquals(os.path.join(self._varsDir, "myTestFlag"), flag.getPath())


class FlagTests(VariablesTestCase):
	def setUp(self):
		super(FlagTests, self).setUp()
		
		self._flagPath = os.path.join(self._varsDir, "SimpleTestFlag")
		
		PathOperations.safeRemove(self._flagPath)		
			
		self._flag = Flag(self._flagPath)
		
	
	def testTheFlagShouldNotBeActiveByDefault(self):
		self.assertFalse(self._flag.isActive())
		
		
	def testActivateShouldWork(self):
		self._flag.activate()
		self.assertTrue(self._flag.isActive())
		
	
	def testActivateShouldBeCalledMultipleTimesWithoutEffects(self):
		self._flag.activate()
		self._flag.activate()
		self.assertTrue(self._flag.isActive())
		
		
	def testDeactivateShouldWork(self):
		self._flag.activate()
		self._flag.deactivate()
		self.assertFalse(self._flag.isActive())
		
	
	def testDeactivateShouldBeCalledMultipleTimesWithoutEffects(self):
		self._flag.activate()
		self._flag.deactivate()
		self._flag.deactivate()
		self.assertFalse(self._flag.isActive())
		
	
	def testShouldWorkFromActiveToInactive(self):
		self._flag.activate()
		self._flag.flip()
		
		self.assertFalse(self._flag.isActive())
		
	
	def testShouldWorkFromInactiveToActive(self):
		self._flag.deactivate()
		self._flag.flip()
		
		self.assertTrue(self._flag.isActive())