/*
 * Decompiled with CFR 0.152.
 */
package japa.parser.ast.body;

public final class ModifierSet {
    public static final int PUBLIC = 1;
    public static final int PROTECTED = 2;
    public static final int PRIVATE = 4;
    public static final int ABSTRACT = 8;
    public static final int STATIC = 16;
    public static final int FINAL = 32;
    public static final int SYNCHRONIZED = 64;
    public static final int NATIVE = 128;
    public static final int TRANSIENT = 256;
    public static final int VOLATILE = 512;
    public static final int STRICTFP = 4096;

    public static int addModifier(int modifiers, int mod) {
        return modifiers |= mod;
    }

    public static boolean hasModifier(int modifiers, int modifier) {
        return (modifiers & modifier) != 0;
    }

    public static boolean isAbstract(int modifiers) {
        return (modifiers & 8) != 0;
    }

    public static boolean isFinal(int modifiers) {
        return (modifiers & 0x20) != 0;
    }

    public static boolean isNative(int modifiers) {
        return (modifiers & 0x80) != 0;
    }

    public static boolean isPrivate(int modifiers) {
        return (modifiers & 4) != 0;
    }

    public static boolean isProtected(int modifiers) {
        return (modifiers & 2) != 0;
    }

    public static boolean isPublic(int modifiers) {
        return (modifiers & 1) != 0;
    }

    public static boolean isStatic(int modifiers) {
        return (modifiers & 0x10) != 0;
    }

    public static boolean isStrictfp(int modifiers) {
        return (modifiers & 0x1000) != 0;
    }

    public static boolean isSynchronized(int modifiers) {
        return (modifiers & 0x40) != 0;
    }

    public static boolean isTransient(int modifiers) {
        return (modifiers & 0x100) != 0;
    }

    public static boolean isVolatile(int modifiers) {
        return (modifiers & 0x200) != 0;
    }

    public static int removeModifier(int modifiers, int mod) {
        return modifiers &= ~mod;
    }

    private ModifierSet() {
    }
}

