
import numpy as np

__version__ = "$Id: definefov.py 32 2013-12-19 22:13:00Z fergalm $"
__URL__ = "$URL: http://svn.code.sf.net/p/keplertwowheel/code/py/definefov.py $"


"""
Code to create, and load, unit vectors representing the
channel corners in the field of view
"""

def generateVectors():
    """Convert the known ra/decs of the channel corners
    into unit vectors. This code creates the conents of the
    function loadOriginVectors() (below)
    """

    ra_deg = 290.66666667
    dec_deg = +44.5
    #rollAngle_deg = 33.0
    rollAngle_deg = +123.
    boresight = r.vecFromRaDec(ra_deg, dec_deg)

    #Read in prime mission coords and convert to vectors
    inFile = "../etc/fov.txt"
    inFile = np.loadtxt(inFile)
    radecs = np.zeros( (len(inFile), 3))
    rotate = radecs*0
    for i, row in enumerate(inFile):
        radecs[i, :] = r.vecFromRaDec(inFile[i, 4], inFile[i,5])
        rotate[i, :] = r.rotateAroundVector(radecs[i], boresight,\
            -rollAngle_deg)




    #Slew to ra/dec of zero
    Ra = r.rightAscensionRotationMatrix(-ra_deg)
    Rd = r.declinationRotationMatrix(-dec_deg)
    R = np.dot(Rd, Ra)
    origin = rotate*0
    for i, row in enumerate(rotate):
        origin[i] = np.dot(R, rotate[i])

    mp.plot(origin[:,0], origin[:,1])

    #Print out the results
    #import pdb; pdb.set_trace()
    print "["
    for i in range(len(inFile)):
        ch = channelFromModOut(inFile[i,0], inFile[i,1])
        print "[%3i., %3i., %3i., %13.7f, %13.7f, %13.7f], \\" %( \
            inFile[i, 0], inFile[i, 1], ch, \
            origin[i, 0], origin[i, 1], origin[i,2])
    print "]"





def loadOriginVectors():
    """Vectors defining corners of channels

    If the spacecraft was pointed at (ra, dec) = (0,0) with mod3
    pointed north, r.raDecFromVec() of these values would give
    The ra and decs of the corners* of the modules.

    *For the FGS sensors, returned vectors are for the corners of
    the modules, within my ability to define that term. For the
    science pixels, the values returned at 5 pixels inside the
    corners of the science collection parts of the CCD (as opposed
    to smear, overscan etc., columns)
    """

    #Columns are mod, out, channel, x, y, z
    #x,y and z make up a unit vector
    return np.array(\
        [
            [  2.,   1.,   1.,     0.9943511,     0.0708017,     0.0790761], \
            [  2.,   1.,   1.,     0.9956156,     0.0498513,     0.0791475], \
            [  2.,   1.,   1.,     0.9938789,     0.0498206,     0.0986038], \
            [  2.,   1.,   1.,     0.9926144,     0.0707811,     0.0985222], \
            [  2.,   2.,   2.,     0.9964468,     0.0286667,     0.0791962], \
            [  2.,   2.,   2.,     0.9956262,     0.0496395,     0.0791481], \
            [  2.,   2.,   2.,     0.9938894,     0.0496086,     0.0986044], \
            [  2.,   2.,   2.,     0.9947111,     0.0286258,     0.0986426], \
            [  2.,   3.,   3.,     0.9923909,     0.0285854,     0.1197627], \
            [  2.,   3.,   3.,     0.9915692,     0.0495596,     0.1197261], \
            [  2.,   3.,   3.,     0.9937189,     0.0496034,     0.1003108], \
            [  2.,   3.,   3.,     0.9945398,     0.0286204,     0.1003563], \
            [  2.,   4.,   4.,     0.9902968,     0.0707233,     0.1196261], \
            [  2.,   4.,   4.,     0.9915587,     0.0497715,     0.1197255], \
            [  2.,   4.,   4.,     0.9937084,     0.0498154,     0.1003102], \
            [  2.,   4.,   4.,     0.9924448,     0.0707762,     0.1002197], \
            [  3.,   1.,   5.,     0.9966269,     0.0211550,     0.0792924], \
            [  3.,   1.,   5.,     0.9968499,     0.0001681,     0.0793111], \
            [  3.,   1.,   5.,     0.9951106,     0.0001748,     0.0987669], \
            [  3.,   1.,   5.,     0.9948882,     0.0211718,     0.0987379], \
            [  3.,   2.,   6.,     0.9966284,    -0.0210311,     0.0793067], \
            [  3.,   2.,   6.,     0.9968499,    -0.0000440,     0.0793112], \
            [  3.,   2.,   6.,     0.9951106,    -0.0000374,     0.0987669], \
            [  3.,   2.,   6.,     0.9948897,    -0.0210346,     0.0987524], \
            [  3.,   3.,   7.,     0.9925746,    -0.0210429,     0.1198032], \
            [  3.,   3.,   7.,     0.9927943,    -0.0000531,     0.1198312], \
            [  3.,   3.,   7.,     0.9949457,    -0.0000568,     0.1004148], \
            [  3.,   3.,   7.,     0.9947247,    -0.0210562,     0.1003961], \
            [  3.,   4.,   8.,     0.9925734,     0.0211486,     0.1197949], \
            [  3.,   4.,   8.,     0.9927943,     0.0001589,     0.1198311], \
            [  3.,   4.,   8.,     0.9949457,     0.0001553,     0.1004147], \
            [  3.,   4.,   8.,     0.9947234,     0.0211545,     0.1003880], \
            [  4.,   1.,   9.,     0.9964472,    -0.0285265,     0.0792410], \
            [  4.,   1.,   9.,     0.9956298,    -0.0495018,     0.0791890], \
            [  4.,   1.,   9.,     0.9938918,    -0.0494754,     0.0986469], \
            [  4.,   1.,   9.,     0.9947103,    -0.0284908,     0.0986896], \
            [  4.,   2.,  10.,     0.9943579,    -0.0706670,     0.0791114], \
            [  4.,   2.,  10.,     0.9956193,    -0.0497137,     0.0791884], \
            [  4.,   2.,  10.,     0.9938813,    -0.0496873,     0.0986463], \
            [  4.,   2.,  10.,     0.9926200,    -0.0706498,     0.0985601], \
            [  4.,   3.,  11.,     0.9903037,    -0.0705737,     0.1196574], \
            [  4.,   3.,  11.,     0.9915643,    -0.0496236,     0.1197404], \
            [  4.,   3.,  11.,     0.9937134,    -0.0496843,     0.1003253], \
            [  4.,   3.,  11.,     0.9924508,    -0.0706450,     0.1002529], \
            [  4.,   4.,  12.,     0.9923958,    -0.0284397,     0.1197573], \
            [  4.,   4.,  12.,     0.9915748,    -0.0494118,     0.1197408], \
            [  4.,   4.,  12.,     0.9937239,    -0.0494724,     0.1003258], \
            [  4.,   4.,  12.,     0.9945439,    -0.0284896,     0.1003529], \
            [  6.,   1.,  13.,     0.9964407,     0.0793218,     0.0285320], \
            [  6.,   1.,  13.,     0.9956219,     0.0792872,     0.0495042], \
            [  6.,   1.,  13.,     0.9938830,     0.0987428,     0.0494609], \
            [  6.,   1.,  13.,     0.9947030,     0.0987674,     0.0284787], \
            [  6.,   2.,  14.,     0.9943486,     0.0792285,     0.0706662], \
            [  6.,   2.,  14.,     0.9956113,     0.0792867,     0.0497161], \
            [  6.,   2.,  14.,     0.9938725,     0.0987423,     0.0496728], \
            [  6.,   2.,  14.,     0.9926099,     0.0986742,     0.0706329], \
            [  6.,   3.,  15.,     0.9902908,     0.1197704,     0.0705638], \
            [  6.,   3.,  15.,     0.9915521,     0.1198462,     0.0496119], \
            [  6.,   3.,  15.,     0.9937031,     0.1004305,     0.0496785], \
            [  6.,   3.,  15.,     0.9924399,     0.1003644,     0.0706401], \
            [  6.,   4.,  16.,     0.9923840,     0.1198578,     0.0284260], \
            [  6.,   4.,  16.,     0.9915626,     0.1198466,     0.0493999], \
            [  6.,   4.,  16.,     0.9937136,     0.1004309,     0.0494664], \
            [  6.,   4.,  16.,     0.9945341,     0.1004519,     0.0284828], \
            [  7.,   1.,  17.,     0.9970461,     0.0709579,     0.0293965], \
            [  7.,   1.,  17.,     0.9983157,     0.0500083,     0.0294099], \
            [  7.,   1.,  17.,     0.9975510,     0.0499816,     0.0489274], \
            [  7.,   1.,  17.,     0.9962810,     0.0709407,     0.0489044], \
            [  7.,   2.,  18.,     0.9991514,     0.0288247,     0.0294212], \
            [  7.,   2.,  18.,     0.9983263,     0.0497964,     0.0294100], \
            [  7.,   2.,  18.,     0.9975616,     0.0497697,     0.0489276], \
            [  7.,   2.,  18.,     0.9983873,     0.0287883,     0.0489292], \
            [  7.,   3.,  19.,     0.9971260,     0.0287429,     0.0700965], \
            [  7.,   3.,  19.,     0.9963014,     0.0497160,     0.0700848], \
            [  7.,   3.,  19.,     0.9974800,     0.0497446,     0.0505869], \
            [  7.,   3.,  19.,     0.9983044,     0.0287622,     0.0506078], \
            [  7.,   4.,  20.,     0.9950235,     0.0708788,     0.0700313], \
            [  7.,   4.,  20.,     0.9962908,     0.0499279,     0.0700845], \
            [  7.,   4.,  20.,     0.9974695,     0.0499565,     0.0505865], \
            [  7.,   4.,  20.,     0.9962009,     0.0709167,     0.0505426], \
            [  8.,   1.,  21.,     0.9993411,     0.0211486,     0.0294986], \
            [  8.,   1.,  21.,     0.9995648,     0.0001607,     0.0295004], \
            [  8.,   1.,  21.,     0.9987979,     0.0001607,     0.0490183], \
            [  8.,   1.,  21.,     0.9985743,     0.0211573,     0.0490076], \
            [  8.,   2.,  22.,     0.9993434,    -0.0210394,     0.0294985], \
            [  8.,   2.,  22.,     0.9995648,    -0.0000514,     0.0295005], \
            [  8.,   2.,  22.,     0.9987979,    -0.0000515,     0.0490183], \
            [  8.,   2.,  22.,     0.9985766,    -0.0210484,     0.0490075], \
            [  8.,   3.,  23.,     0.9973127,    -0.0210356,     0.0701780], \
            [  8.,   3.,  23.,     0.9975337,    -0.0000493,     0.0701885], \
            [  8.,   3.,  23.,     0.9987143,    -0.0000596,     0.0506918], \
            [  8.,   3.,  23.,     0.9984924,    -0.0210557,     0.0506913], \
            [  8.,   4.,  24.,     0.9973118,     0.0211488,     0.0701559], \
            [  8.,   4.,  24.,     0.9975337,     0.0001628,     0.0701884], \
            [  8.,   4.,  24.,     0.9987143,     0.0001526,     0.0506917], \
            [  8.,   4.,  24.,     0.9984915,     0.0211487,     0.0506693], \
            [  9.,   1.,  25.,     0.9970542,    -0.0293798,     0.0708505], \
            [  9.,   1.,  25.,     0.9983205,    -0.0294299,     0.0498998], \
            [  9.,   1.,  25.,     0.9975537,    -0.0489483,     0.0499073], \
            [  9.,   1.,  25.,     0.9962870,    -0.0488886,     0.0708675], \
            [  9.,   2.,  26.,     0.9991529,    -0.0294782,     0.0287151], \
            [  9.,   2.,  26.,     0.9983311,    -0.0294304,     0.0496880], \
            [  9.,   2.,  26.,     0.9975642,    -0.0489488,     0.0496953], \
            [  9.,   2.,  26.,     0.9983866,    -0.0489871,     0.0287129], \
            [  9.,   3.,  27.,     0.9971259,    -0.0701254,     0.0286786], \
            [  9.,   3.,  27.,     0.9963022,    -0.0701199,     0.0496503], \
            [  9.,   3.,  27.,     0.9974813,    -0.0506224,     0.0496835], \
            [  9.,   3.,  27.,     0.9983046,    -0.0506383,     0.0287015], \
            [  9.,   4.,  28.,     0.9950256,    -0.0700703,     0.0708117], \
            [  9.,   4.,  28.,     0.9962916,    -0.0701197,     0.0498621], \
            [  9.,   4.,  28.,     0.9974707,    -0.0506221,     0.0498955], \
            [  9.,   4.,  28.,     0.9962032,    -0.0505831,     0.0708554], \
            [ 10.,   1.,  29.,     0.9943574,    -0.0790863,     0.0707014], \
            [ 10.,   1.,  29.,     0.9956189,    -0.0791704,     0.0497491], \
            [ 10.,   1.,  29.,     0.9938811,    -0.0986276,     0.0497294], \
            [ 10.,   1.,  29.,     0.9926197,    -0.0985342,     0.0706911], \
            [ 10.,   2.,  30.,     0.9964471,    -0.0792303,     0.0285626], \
            [ 10.,   2.,  30.,     0.9956294,    -0.0791711,     0.0495372], \
            [ 10.,   2.,  30.,     0.9938916,    -0.0986283,     0.0495175], \
            [ 10.,   2.,  30.,     0.9947102,    -0.0986783,     0.0285335], \
            [ 10.,   3.,  31.,     0.9923973,    -0.1197356,     0.0284766], \
            [ 10.,   3.,  31.,     0.9915784,    -0.1196952,     0.0494505], \
            [ 10.,   3.,  31.,     0.9937278,    -0.1002792,     0.0494897], \
            [ 10.,   3.,  31.,     0.9945458,    -0.1003294,     0.0285060], \
            [ 10.,   4.,  32.,     0.9903090,    -0.1195895,     0.0706144], \
            [ 10.,   4.,  32.,     0.9915679,    -0.1196944,     0.0496624], \
            [ 10.,   4.,  32.,     0.9937173,    -0.1002785,     0.0497016], \
            [ 10.,   4.,  32.,     0.9924566,    -0.1001832,     0.0706632], \
            [ 11.,   1.,  33.,     0.9966234,     0.0793404,    -0.0211397], \
            [ 11.,   1.,  33.,     0.9968462,     0.0793578,    -0.0001527], \
            [ 11.,   1.,  33.,     0.9951060,     0.0988128,    -0.0001574], \
            [ 11.,   1.,  33.,     0.9948838,     0.0987859,    -0.0211539], \
            [ 11.,   2.,  34.,     0.9966246,     0.0793507,     0.0210465], \
            [ 11.,   2.,  34.,     0.9968462,     0.0793579,     0.0000594], \
            [ 11.,   2.,  34.,     0.9951060,     0.0988129,     0.0000548], \
            [ 11.,   2.,  34.,     0.9948850,     0.0987962,     0.0210513], \
            [ 11.,   3.,  35.,     0.9925637,     0.1198953,     0.0210342], \
            [ 11.,   3.,  35.,     0.9927832,     0.1199233,     0.0000453], \
            [ 11.,   3.,  35.,     0.9949362,     0.1005088,     0.0000482], \
            [ 11.,   3.,  35.,     0.9947155,     0.1004893,     0.0210457], \
            [ 11.,   4.,  36.,     0.9925619,     0.1198890,    -0.0211557], \
            [ 11.,   4.,  36.,     0.9927831,     0.1199233,    -0.0001668], \
            [ 11.,   4.,  36.,     0.9949362,     0.1005087,    -0.0001640], \
            [ 11.,   4.,  36.,     0.9947137,     0.1004830,    -0.0211615], \
            [ 12.,   1.,  37.,     0.9993385,     0.0295867,    -0.0211447], \
            [ 12.,   1.,  37.,     0.9995621,     0.0295891,    -0.0001572], \
            [ 12.,   1.,  37.,     0.9987935,     0.0491072,    -0.0001583], \
            [ 12.,   1.,  37.,     0.9985700,     0.0490953,    -0.0211553], \
            [ 12.,   2.,  38.,     0.9993406,     0.0295892,     0.0210426], \
            [ 12.,   2.,  38.,     0.9995621,     0.0295891,     0.0000549], \
            [ 12.,   2.,  38.,     0.9987935,     0.0491072,     0.0000538], \
            [ 12.,   2.,  38.,     0.9985721,     0.0490978,     0.0210509], \
            [ 12.,   3.,  39.,     0.9973077,     0.0702445,     0.0210470], \
            [ 12.,   3.,  39.,     0.9975289,     0.0702576,     0.0000590], \
            [ 12.,   3.,  39.,     0.9987109,     0.0507600,     0.0000663], \
            [ 12.,   3.,  39.,     0.9984889,     0.0507563,     0.0210635], \
            [ 12.,   4.,  40.,     0.9973068,     0.0702290,    -0.0211410], \
            [ 12.,   4.,  40.,     0.9975289,     0.0702575,    -0.0001531], \
            [ 12.,   4.,  40.,     0.9987109,     0.0507599,    -0.0001460], \
            [ 12.,   4.,  40.,     0.9984880,     0.0507407,    -0.0211433], \
            [ 13.,   1.,  41.,     0.9995705,    -0.0203037,    -0.0211309], \
            [ 13.,   1.,  41.,     0.9997934,    -0.0203258,    -0.0001440], \
            [ 13.,   1.,  41.,     0.9999997,    -0.0007942,    -0.0001330], \
            [ 13.,   1.,  41.,     0.9997764,    -0.0007818,    -0.0211296], \
            [ 13.,   2.,  42.,     0.9995716,    -0.0203276,     0.0210549], \
            [ 13.,   2.,  42.,     0.9997934,    -0.0203259,     0.0000680], \
            [ 13.,   2.,  42.,     0.9999997,    -0.0007943,     0.0000792], \
            [ 13.,   2.,  42.,     0.9997776,    -0.0008058,     0.0210756], \
            [ 13.,   3.,  43.,     0.9995700,     0.0203846,     0.0210796], \
            [ 13.,   3.,  43.,     0.9997918,     0.0204049,     0.0000930], \
            [ 13.,   3.,  43.,     0.9999996,     0.0008730,     0.0000839], \
            [ 13.,   3.,  43.,     0.9997774,     0.0008629,     0.0210808], \
            [ 13.,   4.,  44.,     0.9995690,     0.0204042,    -0.0211058], \
            [ 13.,   4.,  44.,     0.9997918,     0.0204050,    -0.0001192], \
            [ 13.,   4.,  44.,     0.9999996,     0.0008731,    -0.0001282], \
            [ 13.,   4.,  44.,     0.9997765,     0.0008824,    -0.0211251], \
            [ 14.,   1.,  45.,     0.9993453,    -0.0294346,     0.0210397], \
            [ 14.,   1.,  45.,     0.9995660,    -0.0294602,     0.0000500], \
            [ 14.,   1.,  45.,     0.9987997,    -0.0489804,     0.0000728], \
            [ 14.,   1.,  45.,     0.9985792,    -0.0489453,     0.0210721], \
            [ 14.,   2.,  46.,     0.9993414,    -0.0294837,    -0.0211518], \
            [ 14.,   2.,  46.,     0.9995659,    -0.0294605,    -0.0001622], \
            [ 14.,   2.,  46.,     0.9987997,    -0.0489807,    -0.0001394], \
            [ 14.,   2.,  46.,     0.9985753,    -0.0489944,    -0.0211387], \
            [ 14.,   3.,  47.,     0.9973115,    -0.0701699,    -0.0211159], \
            [ 14.,   3.,  47.,     0.9975341,    -0.0701836,    -0.0001281], \
            [ 14.,   3.,  47.,     0.9987147,    -0.0506845,    -0.0001363], \
            [ 14.,   3.,  47.,     0.9984912,    -0.0506818,    -0.0211350], \
            [ 14.,   4.,  48.,     0.9973137,    -0.0701522,     0.0210718], \
            [ 14.,   4.,  48.,     0.9975341,    -0.0701835,     0.0000840], \
            [ 14.,   4.,  48.,     0.9987147,    -0.0506844,     0.0000759], \
            [ 14.,   4.,  48.,     0.9984934,    -0.0506641,     0.0210745], \
            [ 15.,   1.,  49.,     0.9966278,    -0.0793003,     0.0210842], \
            [ 15.,   1.,  49.,     0.9968502,    -0.0793070,     0.0000959], \
            [ 15.,   1.,  49.,     0.9951109,    -0.0987634,     0.0000909], \
            [ 15.,   1.,  49.,     0.9948891,    -0.0987470,     0.0210888], \
            [ 15.,   2.,  50.,     0.9966282,    -0.0792893,    -0.0211045], \
            [ 15.,   2.,  50.,     0.9968502,    -0.0793070,    -0.0001163], \
            [ 15.,   2.,  50.,     0.9951109,    -0.0987634,    -0.0001213], \
            [ 15.,   2.,  50.,     0.9948895,    -0.0987361,    -0.0211193], \
            [ 15.,   3.,  51.,     0.9925702,    -0.1198272,    -0.0211147], \
            [ 15.,   3.,  51.,     0.9927911,    -0.1198575,    -0.0001255], \
            [ 15.,   3.,  51.,     0.9949429,    -0.1004417,    -0.0001272], \
            [ 15.,   3.,  51.,     0.9947207,    -0.1004208,    -0.0211259], \
            [ 15.,   4.,  52.,     0.9925715,    -0.1198236,     0.0210758], \
            [ 15.,   4.,  52.,     0.9927911,    -0.1198575,     0.0000867], \
            [ 15.,   4.,  52.,     0.9949429,    -0.1004417,     0.0000850], \
            [ 15.,   4.,  52.,     0.9947220,    -0.1004173,     0.0210837], \
            [ 16.,   1.,  53.,     0.9943411,     0.0792027,    -0.0708012], \
            [ 16.,   1.,  53.,     0.9956060,     0.0792679,    -0.0498521], \
            [ 16.,   1.,  53.,     0.9938674,     0.0987225,    -0.0498151], \
            [ 16.,   1.,  53.,     0.9926025,     0.0986475,    -0.0707739], \
            [ 16.,   2.,  54.,     0.9964377,     0.0793097,    -0.0286689], \
            [ 16.,   2.,  54.,     0.9956166,     0.0792685,    -0.0496402], \
            [ 16.,   2.,  54.,     0.9938779,     0.0987231,    -0.0496031], \
            [ 16.,   2.,  54.,     0.9947001,     0.0987547,    -0.0286221], \
            [ 16.,   3.,  55.,     0.9923871,     0.1198030,    -0.0285493], \
            [ 16.,   3.,  55.,     0.9915646,     0.1197799,    -0.0495224], \
            [ 16.,   3.,  55.,     0.9937146,     0.1003653,    -0.0495785], \
            [ 16.,   3.,  55.,     0.9945364,     0.1003976,    -0.0285961], \
            [ 16.,   4.,  56.,     0.9902915,     0.1196929,    -0.0706852], \
            [ 16.,   4.,  56.,     0.9915540,     0.1197794,    -0.0497342], \
            [ 16.,   4.,  56.,     0.9937041,     0.1003648,    -0.0497905], \
            [ 16.,   4.,  56.,     0.9924398,     0.1002875,    -0.0707505], \
            [ 17.,   1.,  57.,     0.9970438,     0.0294789,    -0.0709549], \
            [ 17.,   1.,  57.,     0.9983130,     0.0295051,    -0.0500051], \
            [ 17.,   1.,  57.,     0.9975458,     0.0490231,    -0.0499906], \
            [ 17.,   1.,  57.,     0.9962762,     0.0489870,    -0.0709502], \
            [ 17.,   2.,  58.,     0.9991483,     0.0295300,    -0.0288212], \
            [ 17.,   2.,  58.,     0.9983236,     0.0295054,    -0.0497933], \
            [ 17.,   2.,  58.,     0.9975564,     0.0490234,    -0.0497786], \
            [ 17.,   2.,  58.,     0.9983817,     0.0490382,    -0.0287967], \
            [ 17.,   3.,  59.,     0.9971197,     0.0701842,    -0.0287501], \
            [ 17.,   3.,  59.,     0.9962941,     0.0701824,    -0.0497241], \
            [ 17.,   3.,  59.,     0.9974743,     0.0506835,    -0.0497618], \
            [ 17.,   3.,  59.,     0.9982995,     0.0506948,    -0.0287783], \
            [ 17.,   4.,  60.,     0.9950153,     0.0701384,    -0.0708877], \
            [ 17.,   4.,  60.,     0.9962835,     0.0701822,    -0.0499360], \
            [ 17.,   4.,  60.,     0.9974637,     0.0506833,    -0.0499738], \
            [ 17.,   4.,  60.,     0.9961942,     0.0506491,    -0.0709351], \
            [ 18.,   1.,  61.,     0.9993404,    -0.0210663,    -0.0295798], \
            [ 18.,   1.,  61.,     0.9995627,    -0.0000796,    -0.0295687], \
            [ 18.,   1.,  61.,     0.9987946,    -0.0000679,    -0.0490857], \
            [ 18.,   1.,  61.,     0.9985723,    -0.0210640,    -0.0490876], \
            [ 18.,   2.,  62.,     0.9993400,     0.0211192,    -0.0295546], \
            [ 18.,   2.,  62.,     0.9995627,     0.0001325,    -0.0295685], \
            [ 18.,   2.,  62.,     0.9987946,     0.0001442,    -0.0490856], \
            [ 18.,   2.,  62.,     0.9985720,     0.0211402,    -0.0490623], \
            [ 18.,   3.,  63.,     0.9973050,     0.0211147,    -0.0702634], \
            [ 18.,   3.,  63.,     0.9975274,     0.0001276,    -0.0702790], \
            [ 18.,   3.,  63.,     0.9987098,     0.0001332,    -0.0507816], \
            [ 18.,   3.,  63.,     0.9984865,     0.0211304,    -0.0507759], \
            [ 18.,   4.,  64.,     0.9973067,    -0.0210716,    -0.0702515], \
            [ 18.,   4.,  64.,     0.9975274,    -0.0000845,    -0.0702789], \
            [ 18.,   4.,  64.,     0.9987098,    -0.0000789,    -0.0507814], \
            [ 18.,   4.,  64.,     0.9984883,    -0.0210761,    -0.0507640], \
            [ 19.,   1.,  65.,     0.9970512,    -0.0708561,    -0.0294677], \
            [ 19.,   1.,  65.,     0.9983183,    -0.0499066,    -0.0294934], \
            [ 19.,   1.,  65.,     0.9975514,    -0.0498915,    -0.0490109], \
            [ 19.,   1.,  65.,     0.9962839,    -0.0708508,    -0.0489754], \
            [ 19.,   2.,  66.,     0.9991515,    -0.0287231,    -0.0295176], \
            [ 19.,   2.,  66.,     0.9983289,    -0.0496948,    -0.0294937], \
            [ 19.,   2.,  66.,     0.9975620,    -0.0496796,    -0.0490111], \
            [ 19.,   2.,  66.,     0.9983852,    -0.0286981,    -0.0490253], \
            [ 19.,   3.,  67.,     0.9971176,    -0.0286911,    -0.0702370], \
            [ 19.,   3.,  67.,     0.9962940,    -0.0496628,    -0.0702267], \
            [ 19.,   3.,  67.,     0.9974754,    -0.0496921,    -0.0507297], \
            [ 19.,   3.,  67.,     0.9982986,    -0.0287105,    -0.0507499], \
            [ 19.,   4.,  68.,     0.9950174,    -0.0708242,    -0.0701733], \
            [ 19.,   4.,  68.,     0.9962835,    -0.0498746,    -0.0702263], \
            [ 19.,   4.,  68.,     0.9974648,    -0.0499040,    -0.0507293], \
            [ 19.,   4.,  68.,     0.9961974,    -0.0708634,    -0.0506861], \
            [ 20.,   1.,  69.,     0.9964443,    -0.0792385,    -0.0286342], \
            [ 20.,   1.,  69.,     0.9956234,    -0.0792020,    -0.0496102], \
            [ 20.,   1.,  69.,     0.9938858,    -0.0986605,    -0.0495696], \
            [ 20.,   1.,  69.,     0.9947078,    -0.0986880,    -0.0285843], \
            [ 20.,   2.,  70.,     0.9943479,    -0.0791394,    -0.0707762], \
            [ 20.,   2.,  70.,     0.9956128,    -0.0792015,    -0.0498222], \
            [ 20.,   2.,  70.,     0.9938752,    -0.0986600,    -0.0497815], \
            [ 20.,   2.,  70.,     0.9926104,    -0.0985889,    -0.0707446], \
            [ 20.,   3.,  71.,     0.9902932,    -0.1196918,    -0.0706635], \
            [ 20.,   3.,  71.,     0.9915574,    -0.1197616,    -0.0497105], \
            [ 20.,   3.,  71.,     0.9937065,    -0.1003444,    -0.0497832], \
            [ 20.,   3.,  71.,     0.9924404,    -0.1002846,    -0.0707463], \
            [ 20.,   4.,  72.,     0.9923923,    -0.1197664,    -0.0285238], \
            [ 20.,   4.,  72.,     0.9915679,    -0.1197620,    -0.0494986], \
            [ 20.,   4.,  72.,     0.9937171,    -0.1003448,    -0.0495713], \
            [ 20.,   4.,  72.,     0.9945405,    -0.1003592,    -0.0285861], \
            [ 22.,   1.,  73.,     0.9964368,     0.0286133,    -0.0793405], \
            [ 22.,   1.,  73.,     0.9956177,     0.0495863,    -0.0792878], \
            [ 22.,   1.,  73.,     0.9938780,     0.0495599,    -0.0987440], \
            [ 22.,   1.,  73.,     0.9946982,     0.0285770,    -0.0987869], \
            [ 22.,   2.,  74.,     0.9943441,     0.0707490,    -0.0792105], \
            [ 22.,   2.,  74.,     0.9956072,     0.0497981,    -0.0792872], \
            [ 22.,   2.,  74.,     0.9938675,     0.0497718,    -0.0987433], \
            [ 22.,   2.,  74.,     0.9926045,     0.0707325,    -0.0986567], \
            [ 22.,   3.,  75.,     0.9902909,     0.0706773,    -0.1197020], \
            [ 22.,   3.,  75.,     0.9915526,     0.0497252,    -0.1197947], \
            [ 22.,   3.,  75.,     0.9937034,     0.0497756,    -0.1003792], \
            [ 22.,   3.,  75.,     0.9924400,     0.0707368,    -0.1002956], \
            [ 22.,   4.,  76.,     0.9923848,     0.0285391,    -0.1198247], \
            [ 22.,   4.,  76.,     0.9915632,     0.0495133,    -0.1197953], \
            [ 22.,   4.,  76.,     0.9937139,     0.0495636,    -0.1003798], \
            [ 22.,   4.,  76.,     0.9945347,     0.0285802,    -0.1004182], \
            [ 23.,   1.,  77.,     0.9966224,    -0.0210791,    -0.0793690], \
            [ 23.,   1.,  77.,     0.9968447,    -0.0000897,    -0.0793765], \
            [ 23.,   1.,  77.,     0.9951040,    -0.0000849,    -0.0988332], \
            [ 23.,   1.,  77.,     0.9948823,    -0.0210834,    -0.0988166], \
            [ 23.,   2.,  78.,     0.9966226,     0.0211118,    -0.0793585], \
            [ 23.,   2.,  78.,     0.9968447,     0.0001224,    -0.0793764], \
            [ 23.,   2.,  78.,     0.9951040,     0.0001273,    -0.0988331], \
            [ 23.,   2.,  78.,     0.9948824,     0.0211257,    -0.0988062], \
            [ 23.,   3.,  79.,     0.9925612,     0.0211055,    -0.1199038], \
            [ 23.,   3.,  79.,     0.9927824,     0.0001164,    -0.1199299], \
            [ 23.,   3.,  79.,     0.9949356,     0.0001219,    -0.1005144], \
            [ 23.,   3.,  79.,     0.9947131,     0.0211204,    -0.1004977], \
            [ 23.,   4.,  80.,     0.9925630,    -0.0210847,    -0.1198920], \
            [ 23.,   4.,  80.,     0.9927824,    -0.0000957,    -0.1199298], \
            [ 23.,   4.,  80.,     0.9949356,    -0.0000903,    -0.1005143], \
            [ 23.,   4.,  80.,     0.9947150,    -0.0210887,    -0.1004859], \
            [ 24.,   1.,  81.,     0.9943468,    -0.0707197,    -0.0792032], \
            [ 24.,   1.,  81.,     0.9956106,    -0.0497671,    -0.0792638], \
            [ 24.,   1.,  81.,     0.9938720,    -0.0497255,    -0.0987212], \
            [ 24.,   1.,  81.,     0.9926083,    -0.0706875,    -0.0986512], \
            [ 24.,   2.,  82.,     0.9964410,    -0.0285805,    -0.0793000], \
            [ 24.,   2.,  82.,     0.9956211,    -0.0495552,    -0.0792642], \
            [ 24.,   2.,  82.,     0.9938825,    -0.0495135,    -0.0987216], \
            [ 24.,   2.,  82.,     0.9947034,    -0.0285293,    -0.0987480], \
            [ 24.,   3.,  83.,     0.9923834,    -0.0284838,    -0.1198492], \
            [ 24.,   3.,  83.,     0.9915621,    -0.0494595,    -0.1198261], \
            [ 24.,   3.,  83.,     0.9937134,    -0.0495148,    -0.1004085], \
            [ 24.,   3.,  83.,     0.9945339,    -0.0285290,    -0.1004415], \
            [ 24.,   4.,  84.,     0.9902904,    -0.0706251,    -0.1197374], \
            [ 24.,   4.,  84.,     0.9915516,    -0.0496714,    -0.1198256], \
            [ 24.,   4.,  84.,     0.9937029,    -0.0497268,    -0.1004079], \
            [ 24.,   4.,  84.,     0.9924398,    -0.0706905,    -0.1003297], \
            [  1.,   1.,  85.,     0.9928239,     0.0835340,     0.0855732], \
            [  1.,   1.,  85.,     0.9932213,     0.0786506,     0.0855895], \
            [  1.,   1.,  85.,     0.9936436,     0.0786681,     0.0805219], \
            [  1.,   1.,  85.,     0.9932462,     0.0835515,     0.0805056], \
            [  5.,   1.,  86.,     0.9928240,    -0.0855734,     0.0835326], \
            [  5.,   1.,  86.,     0.9932213,    -0.0855903,     0.0786492], \
            [  5.,   1.,  86.,     0.9936437,    -0.0805227,     0.0786660], \
            [  5.,   1.,  86.,     0.9932463,    -0.0805058,     0.0835495], \
            [ 21.,   1.,  87.,     0.9928240,     0.0855734,    -0.0835326], \
            [ 21.,   1.,  87.,     0.9932213,     0.0855903,    -0.0786492], \
            [ 21.,   1.,  87.,     0.9936437,     0.0805227,    -0.0786660], \
            [ 21.,   1.,  87.,     0.9932463,     0.0805058,    -0.0835494], \
            [ 25.,   1.,  88.,     0.9928239,    -0.0835340,    -0.0855733], \
            [ 25.,   1.,  88.,     0.9932213,    -0.0786506,    -0.0855895], \
            [ 25.,   1.,  88.,     0.9936436,    -0.0786680,    -0.0805218], \
            [ 25.,   1.,  88.,     0.9932462,    -0.0835515,    -0.0805056], \
        ])
