#!/usr/bin/env python
#
# (C) 2008 British Broadcasting Corporation and Kamaelia Contributors(1)
#     All Rights Reserved.
#
# You may only modify and redistribute this under the terms of any of the
# following licenses(2): Mozilla Public License, V1.1, GNU General
# Public License, V2.0, GNU Lesser General Public License, V2.1
#
# (1) Kamaelia Contributors are listed in the AUTHORS file and at
#     http://kamaelia.sourceforge.net/AUTHORS - please extend this file,
#     not this notice.
# (2) Reproduced in the COPYING file, and at:
#     http://kamaelia.sourceforge.net/COPYING
# Under section 3.5 of the MPL, we are using this text since we deem the MPL
# notice inappropriate for this file. As per MPL/GPL/LGPL removal of this
# notice is prohibited.
#
# Please contact us via: kamaelia-list-owner@lists.sourceforge.net
# to discuss alternative licensing.
# -------------------------------------------------------------------------

#from distutils.core import setup
from setuptools import setup

setup(name = "Kamaelia",
      version = "0.6.0",
      description = "Kamaelia - Multimedia & Server Development Kit",
      author = "Michael Sparks & Kamaelia Contributors",
      author_email = "ms_@users.sourceforge.net",
      url = "http://edit.kamaelia.org/Developers",
      license = "Copyright (c)2008 BBC & Kamaelia Contributors, All Rights Reserved. Use allowed under MPL 1.1, GPL 2.0, LGPL 2.1",
      packages = [\
                  "Axon", ### START
                  "Axon.experimental", ### LAST
                  "Kamaelia", # START
                  "Kamaelia.Apps",
                  "Kamaelia.Apps.Compose",
                  "Kamaelia.Apps.Compose.GUI",
                  "Kamaelia.Apps.Games4Kids",
                  "Kamaelia.Apps.Grey",
		  "Kamaelia.Apps.IRCLogger",
                  "Kamaelia.Apps.Show",
                  "Kamaelia.Apps.Whiteboard",
                  "Kamaelia.Automata",
                  "Kamaelia.Audio",
                  "Kamaelia.Audio.PyMedia",
                  "Kamaelia.Audio.Codec",
                  "Kamaelia.Audio.Codec.PyMedia",
                  "Kamaelia.Chassis",
                  "Kamaelia.Codec",
                  "Kamaelia.Device",
                  "Kamaelia.Device.DVB",
                  "Kamaelia.Device.DVB.Parse",
                  "Kamaelia.Experimental",
                  "Kamaelia.File",
                  "Kamaelia.Internet",
                  "Kamaelia.Internet.Simulate",
                  "Kamaelia.Protocol",
                  "Kamaelia.Protocol.AIM",
                  "Kamaelia.Protocol.HTTP",
                  "Kamaelia.Protocol.HTTP.Handlers",
                  "Kamaelia.Protocol.IRC",
                  "Kamaelia.Protocol.RTP",
                  "Kamaelia.Protocol.Torrent",
                  "Kamaelia.Support",
                  "Kamaelia.Support.Data",
                  "Kamaelia.Support.DVB",
                  "Kamaelia.Support.Particles",
                  "Kamaelia.Support.Protocol",
                  "Kamaelia.Support.PyMedia",
                  "Kamaelia.Support.Tk",
                  "Kamaelia.UI",
                  "Kamaelia.UI.Tk",
                  "Kamaelia.UI.MH",
                  "Kamaelia.UI.Pygame",  
                  "Kamaelia.UI.OpenGL",
                  "Kamaelia.Util",
                  "Kamaelia.Util.Tokenisation",
                  "Kamaelia.Video",
                  "Kamaelia.Visualisation",
                  "Kamaelia.Visualisation.Axon",
                  "Kamaelia.Visualisation.ER",
                  "Kamaelia.Visualisation.PhysicsGraph",
                  "Kamaelia.XML", # LAST
                  ""],
      data_files=[ ('/usr/local/share/kamaelia', ['App/kamaelia_logo.png']) ],
      long_description = """
Kamaelia is an open source project from BBC R&D. It makes prototyping
multimedia, network & broadcast aware systems simple. Kamaelia systems are
naturally concurrent and transform into production quality, maintainable
systems, with relatively little change from prototype.

It is useful for things from 3D systems through building PVRs through video
playback, through shot change detection, through P2P distribution (live and
bit torrent), through whiteboards, handwriting/gesture recognition, speech
generation, and games systems, and back through DVB on both the reception
side and broadcast side, and lots more not mentioned...
""",
      )

