// Generated by CoffeeScript 1.3.1

/*
    klutil.coffee
    ~~~~~~~~~~~~~

    This is the base file of Kaylee client-side module.
    It contains the common code used by Kaylee.

    :copyright: (c) 2012 by Zaur Nasibov.
    :license: MIT, see LICENSE for more details.
*/


(function() {
  var Event, kl, on_action_received, on_node_registered, on_node_subscribed, on_node_unsubscibed, on_project_imported, on_task_completed, on_task_received, on_worker_error, on_worker_message, util,
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
    __slice = [].slice;

  kl = {};

  kl.util = {};

  util = kl.util;

  util.is_function = function(obj) {
    return typeof obj === 'function';
  };

  Event = (function() {

    Event.name = 'Event';

    function Event(handler) {
      if (handler == null) {
        handler = null;
      }
      this.unbind = __bind(this.unbind, this);

      this.bind = __bind(this.bind, this);

      this.trigger = __bind(this.trigger, this);

      this.handlers = [];
      if (handler != null) {
        this.handlers.push(handler);
      }
      return null;
    }

    Event.prototype.trigger = function() {
      var args, c, _i, _len, _ref;
      args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
      _ref = this.handlers;
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        c = _ref[_i];
        c.apply(null, args);
      }
      return null;
    };

    Event.prototype.bind = function(handler) {
      this.handlers.push(handler);
      return null;
    };

    Event.prototype.unbind = function(handler) {
      var t, _ref;
      if ((t = this.handlers.indexOf(handler)) > -1) {
        [].splice.apply(this.handlers, [t, t - t + 1].concat(_ref = [])), _ref;
      }
      return null;
    };

    return Event;

  })();

  kl.Event = Event;

  /*
      kaylee.coffee
      ~~~~~~~~~~~~~
  
      This is the base file of Kaylee client-side module.
  
      :copyright: (c) 2012 by Zaur Nasibov.
      :license: MIT, see LICENSE for more details.
  */


  kl.config = {};

  kl.api = {
    register: function() {
      kl.get("/kaylee/register", kl.node_registered.trigger, kl.server_raised_error.trigger);
      return null;
    },
    subscribe: function(app_name) {
      kl.post("/kaylee/apps/" + app_name + "/subscribe/" + kl.node_id, null, kl.node_subscribed.trigger, kl.server_raised_error.trigger);
      return null;
    },
    get_action: function() {
      kl.get("/kaylee/actions/" + kl.node_id, kl.action_received.trigger, kl.server_raised_error.trigger);
      return null;
    },
    send_result: function(results) {
      kl.post("/kaylee/actions/" + kl.node_id, results, (function(action_data) {
        kl.result_sent.trigger(results);
        return kl.action_received.trigger(action_data);
      }), kl._default_server_error_handler);
      return null;
    }
  };

  kl.register = function() {
    if (kl._test_node().features.worker) {
      kl.api.register();
    } else {
      kl.log("Node cannot be registered: client does not meet the ", "requirements.");
    }
    return null;
  };

  kl.subscribe = function(app_name) {
    kl.app = {
      name: name,
      config: null,
      worker: null,
      subscribed: false
    };
    kl.api.subscribe(app_name);
    return null;
  };

  kl.get_action = function() {
    if (kl.app.subscribed) {
      kl.api.get_action();
    }
    return null;
  };

  kl.send_result = function(data) {
    if (kl.app.subscribed) {
      kl.api.send_result(data);
    }
    return null;
  };

  kl._message_to_worker = function(msg, data) {
    if (data == null) {
      data = {};
    }
    kl.app.worker.postMessage({
      'msg': msg,
      'data': data
    });
    return null;
  };

  kl._default_server_error_handler = function(err) {
    kl.server_raised_error.trigger(err);
    switch (err) {
      case 'INVALID_STATE_ERR':
        if (kl.app.subscribed) {
          return this.get_action();
        }
    }
  };

  on_node_registered = function(data) {
    var key, val, _ref;
    _ref = data.config;
    for (key in _ref) {
      val = _ref[key];
      kl.config[key] = val;
    }
    kl.node_id = data.node_id;
    return null;
  };

  on_node_subscribed = function(config) {
    var worker;
    kl.app.config = config;
    if (kl.app.worker != null) {
      kl.app.worker.terminate();
    }
    kl.app.subscribed = true;
    worker = new Worker(kl.config.WORKER_SCRIPT);
    kl.app.worker = worker;
    worker.addEventListener('message', (function(e) {
      return on_worker_message(e.data);
    }), false);
    worker.addEventListener('error', (function(e) {
      return on_worker_error(e);
    }), false);
    kl._message_to_worker('import_project', {
      'kl_config': kl.config,
      'app_config': kl.app.config
    });
    return null;
  };

  on_node_unsubscibed = function(data) {
    kl.app.subscribed = false;
    kl.app.worker.terminate();
    kl.app.worker = null;
    return null;
  };

  on_project_imported = function() {
    kl.get_action();
    return null;
  };

  on_action_received = function(data) {
    switch (data.action) {
      case 'task':
        kl.task_received.trigger(data.data);
        break;
      case 'unsubscribe':
        kl.node_unsubscibed.trigger(data.data);
    }
    return null;
  };

  on_task_received = function(data) {
    kl._message_to_worker('solve_task', data);
    return null;
  };

  on_task_completed = function(data) {
    kl.send_result(data);
    return null;
  };

  on_worker_message = function(data) {
    var mdata, msg;
    msg = data.msg;
    mdata = data.data;
    switch (msg) {
      case '__klw_log__':
        kl.log.trigger(mdata);
        break;
      case 'project_imported':
        kl.project_imported.trigger(mdata);
        break;
      case 'task_completed':
        kl.task_completed.trigger(mdata);
    }
    return null;
  };

  on_worker_error = function(e) {
    kl.worker_raised_error.trigger(e);
    return null;
  };

  kl.node_registered = new Event(on_node_registered);

  kl.node_subscribed = new Event(on_node_subscribed);

  kl.node_unsubscibed = new Event(on_node_unsubscibed);

  kl.project_imported = new Event(on_project_imported);

  kl.action_received = new Event(on_action_received);

  kl.task_received = new Event(on_task_received);

  kl.task_completed = new Event(on_task_completed);

  kl.log = new Event();

  kl.worker_raised_error = new Event();

  kl.result_sent = new Event();

  kl.server_raised_error = new Event();

  window.kl = kl;

  /*
      klajax.coffee
      ~~~~~~~~~~~~~
  
      This is the base file of Kaylee client-side module.
      It contains a small AJAX library used in a browser's
      main JavaScript event loop.
  
      :copyright: (c) 2012 by Zaur Nasibov.
      :license: MIT, see LICENSE for more details.
  */


  kl.ajax = function(url, method, data, success, error) {
    var dl, key, req, val;
    if (success == null) {
      success = (function() {});
    }
    if (error == null) {
      error = (function() {});
    }
    req = new XMLHttpRequest();
    switch (method) {
      case "POST":
        if (!(data != null)) {
          data = {};
        }
        data = JSON.stringify(data);
        req.open('POST', url, true);
        req.setRequestHeader('Content-type', 'application/json; charset=utf-8');
        req.setRequestHeader("Content-length", data.length);
        req.setRequestHeader("Connection", "close");
        break;
      case "GET":
        if (data != null) {
          alert(data);
          dl = [];
          for (key in data) {
            val = data[key];
            dl.push(key + '=' + encodeURIComponent(val));
          }
          url += '?' + dl.join('&');
        }
        req.open("GET", url, true);
    }
    req.responseType = 'json';
    req.onreadystatechange = function() {
      if (req.readyState === 4) {
        if (req.status === 200 && (req.response != null)) {
          if (req.response.error != null) {
            error(req.response.error);
          } else {
            success(req.response);
          }
        } else if (!(req.response != null)) {
          error('INVALID_STATE_ERR');
        } else {
          error(req.response);
        }
      }
      return null;
    };
    req.send(data);
    return null;
  };

  kl.post = function(url, data, success, error) {
    var _success;
    _success = function(resp_data) {
      if (resp_data.error != null) {
        return error(resp_data.error);
      } else {
        return success(resp_data);
      }
    };
    kl.ajax(url, 'POST', data, _success, error);
    return null;
  };

  kl.get = function(url, data, success, error) {
    var _success;
    if (arguments.length >= 2) {
      if (kl.util.is_function(data)) {
        error = success;
        success = data;
        data = null;
      }
    }
    _success = function(resp_data) {
      if (resp_data.error != null) {
        return error(resp_data.error);
      } else {
        return success(resp_data);
      }
    };
    kl.ajax(url, 'GET', data, _success, error);
    return null;
  };

  /*
      klbenchmark.coffee
      ~~~~~~~~~~~~~~~~~~
  
      This is the base file of Kaylee client-side module.
      It contains a benchmark executer function.
  
      :copyright: (c) 2012 by Zaur Nasibov.
      :license: MIT, see LICENSE for more details.
  */


  kl._test_node = function() {
    var bWorker;
    bWorker = !!window.Worker;
    if (!bWorker) {
      return {
        'feautres': {
          'worker': false
        }
      };
    } else {
      return {
        features: {
          worker: true
        }
      };
    }
  };

}).call(this);
