// Generated by CoffeeScript 1.3.1
/*
    klworker.coffee
    ~~~~~~~~~~~~~~~

    This is the base file of Kaylee client-side Web Worker module.

    :copyright: (c) 2012 by Zaur Nasibov.
    :license: MIT, see LICENSE for more details.
*/

var klw, pj;

klw = {};

pj = {};

addEventListener('message', (function(e) {
  var mdata, msg;
  msg = e.data.msg;
  mdata = e.data.data;
  switch (msg) {
    case 'import_project':
      return klw.import_project(mdata);
    case 'solve_task':
      return pj.on_task_received(mdata);
  }
}), false);

klw.post_message = function(msg, data) {
  if (data == null) {
    data = {};
  }
  return postMessage({
    'msg': msg,
    'data': data
  });
};

klw.import_project = function(kwargs) {
  importScripts(kwargs.app_config.script);
  pj.init(kwargs.kl_config, kwargs.app_config);
  return klw.post_message('project_imported');
};

klw.task_completed = function(res) {
  return klw.post_message('task_completed', res);
};

klw.log = function(message) {
  return klw.post_message('__klw_log__', message);
};
