from khronos.anim2d.shapes import Shape

def create_box(arena, width, height, x=0, y=0, name="box", 
               wallwidth=50, props={"fill": "black"}):
    half_w  = width / 2
    half_h  = height / 2
    half_ww = wallwidth / 2
    box = Shape.list(**props)
    box.append(Shape.rect(wallwidth, height + 2 * wallwidth, x=-(half_w + half_ww)))
    box.append(Shape.rect(wallwidth, height + 2 * wallwidth, x= (half_w + half_ww)))
    box.append(Shape.rect(width + 2 * wallwidth, wallwidth,  y=-(half_h + half_ww)))
    box.append(Shape.rect(width + 2 * wallwidth, wallwidth,  y= (half_h + half_ww)))
    arena.add_obstacle(name, box, x, y)
    
