from khronos.utils import Reportable, Deque

class ListenerTable(dict, Reportable):
    def insert(self, listener):
        try:
            self[listener.type].add(listener)
        except KeyError:
            self[listener.type] = set([listener])
        listener.__type = listener.type
        
    def remove(self, listener):
        listener_set = self[listener.__type]
        listener_set.remove(listener)
        if len(listener_set) == 0:
            del self[listener.__type]
            
    def match(self, signal, rng):
        matches = Deque()
        for type in (signal.type, None):
            try:
                listener_set = self[type]
            except KeyError:
                continue
            else:
                for listener in listener_set:
                    matches.insort(((listener.priority, rng.random()), listener))
        return matches
        
    def report_items(self):
        items = []
        for type, listeners in self.iteritems():
            items.append((type, ""))
            items.append([(i, "%s :: %s" % (l, l.owner)) for i, l in enumerate(listeners)])
        return items
        
