from khronos.des.primitives.action import Action, DEPLOYING, ONGOING

class Delay(Action):
    def __init__(self, length, priority=0.0):
        Action.__init__(self)
        self.length = length
        self.priority = priority
        
    def info(self):
        return self.length
        
    def deploy(self):
        self.deploy_to(self.owner.sim)
        
    def retract(self):
        self.retract_from(self.owner.sim)
        
    def deploy_to(self, sim):
        raise NotImplementedError()
        
    def retract_from(self, sim):
        raise NotImplementedError()
        
    def finish(self):
        """Called by the simulator when the delay was reached in the event schedule, in order to 
        prevent an invalid attempt to remove it from the schedule at retraction."""
        if self.state is not ONGOING:
            raise ValueError("cannot finish() - unexpected action state '%s'" % (self.state,))
        self.state = DEPLOYING
        self.succeed()
        
