from khronos.des.primitives.action import Action

class Listener(Action):
    """Implements a wait for a signal. Whenever some component broadcasts a signal with the same 
    type, the listener will succeed. If the type is None, the listener will succeed at the first 
    signal, independently of the signal's type. Listeners also have a 'priority' attribute that 
    can be passed to the constructor. It defines the order by which listeners are activated when 
    a signal triggers multiple listeners simultaneously (high priority first)."""
    def __init__(self, type=None, priority=0.0):
        Action.__init__(self)
        self.type = type
        self.priority = priority
        
    def info(self):
        return "*" if self.type is None else self.type
        
    def deploy(self):
        self.deploy_to(self.owner.sim)
        
    def retract(self):
        self.retract_from(self.owner.sim)
        
    def deploy_to(self, sim):
        raise NotImplementedError()
        
    def retract_from(self, sim):
        raise NotImplementedError()
        
