from khronos.des.primitives.action import Action, DEPLOYING
from khronos.des.primitives.dummy import DUMMY

class Renege(Action):
    def __init__(self, main_action, fail_condition):
        Action.__init__(self)
        self.main_action = main_action
        self.fail_condition = fail_condition
        main_action.parent_connect(self, self.__del_main_action)
        fail_condition.parent_connect(self, self.__del_fail_condition)
        
    def __del_main_action(self, _):
        self.main_action = DUMMY
        
    def __del_fail_condition(self, _):
        self.fail_condition = DUMMY
        
    def info(self):
        return "%s if %s" % (self.main_action, self.fail_condition)
        
    def bind(self, owner):
        Action.bind(self, owner)
        self.main_action.bind(owner)
        self.fail_condition.bind(owner)
        
    def reset(self):
        self.main_action.initialize()
        self.fail_condition.initialize()
        
    def deploy(self):
        self.main_action.start()
        if self.state is DEPLOYING:
            self.fail_condition.start()
            
    def retract(self):
        self.main_action.cancel()
        self.fail_condition.cancel()
        
    def succeed(self):
        self.main_action.succeed()
        
    def fail(self):
        self.main_action.fail()
        
    def child_succeeded(self, child):
        if child is self.main_action:
            Action.succeed(self)
        elif child is self.fail_condition:
            self.main_action.fail()
        else:
            raise ValueError("invalid child action provided")
            
    def child_failed(self, child):
        if child is self.main_action:
            Action.fail(self)
        elif child is not self.fail_condition:
            raise ValueError("invalid child action provided")
            
