from khronos.des.primitives.action import Action
from khronos.des.primitives.dummy import DUMMY

class UnaryOp(Action):
    def __init__(self, operand):
        Action.__init__(self)
        self.operand = operand
        operand.parent_connect(self, self.__del_operand)
        
    def set_operand(self, operand):
        operand.parent_connect(self, self.__del_operand)
        self.operand.parent_disconnect()
        self.operand = operand
        
    def __del_operand(self, _):
        self.operand = DUMMY
        
    def info(self):
        return self.operand
        
    def bind(self, owner):
        Action.bind(self, owner)
        self.operand.bind(owner)
        
    def reset(self):
        self.operand.initialize()
        
    def deploy(self):
        self.operand.start()
        
    def retract(self):
        self.operand.cancel()
        
    def child_succeeded(self, child):
        raise NotImplementedError()
        
    def child_failed(self, child):
        raise NotImplementedError()
        
