from khronos.des.primitives.action import Action, DEPLOYING, ONGOING

def dummy_fnc(_):
    pass
    
class Request(Action):
    """Request is the most flexible simulation primitive. It can be used for any case where the 
    owner process blocks until another process verifies a condition and MANUALLY calls the 
    fulfill() method on the primitive.
    TODO: add an example of Request usage.""" 
    def __init__(self, data=None, priority=0.0):
        Action.__init__(self)
        self.data = data
        self.priority = priority
        self.fulfilled = False
        self.result = None
        self.deploy_fnc = dummy_fnc
        self.retract_fnc = dummy_fnc
        
    def info(self):
        info = ""
        if self.data is not None:
            info += str(self.data)
        if self.fulfilled and self.result is not None:
            info += " -> " + str(self.result)
        return info
        
    def configure(self, deploy_fnc=None, retract_fnc=None):
        """Set custom deployment functions for a request. The request's deployment methods will 
        then call these functions. For instance, req.deploy() will call deploy_fnc(req), so the 
        argument functions should take a single argument, which is the request which is asking 
        for the deployment/retraction operation."""
        if deploy_fnc  is not None: self.deploy_fnc  = deploy_fnc
        if retract_fnc is not None: self.retract_fnc = retract_fnc
        
    def deploy(self):
        self.deploy_fnc(self)
        
    def retract(self):
        self.retract_fnc(self)
            
    def reset(self):
        self.fulfilled = False
        self.result = None
        
    def fulfill(self, result=None):
        if self.fulfilled:
            raise ValueError("request is already fulfilled")
        if self.state not in (DEPLOYING, ONGOING):
            raise ValueError("cannot fulfill undeployed request")
        self.fulfilled = True
        self.result = result
        self.succeed()
        
