from khronos.des.primitives.action import Action, SUCCEEDED

class Signal(Action, dict):
    """Signals are an instantaneous primitive that allows synchronizing several components. Signals
    are the counterpart of listeners, which make their owners block until a signal of matching type
    is broadcasted."""
    def __init__(self, type, **attachments):
        Action.__init__(self)
        dict.__init__(self, attachments)
        self.type = type
        
    def info(self):
        if len(self) == 0:
            return self.type
        return "".join([self.type, " - ", dict.__repr__(self)])
        
    def start(self):
        """This replacement of the start() method is intended to make signals activate as soon as 
        they are started. It is a modified copy of Action.succeed(), containing an extra line to 
        broadcast the signal while it is still in the simulation stack. Also, the lines where the 
        action is retracted were removed because signals never really get to be deployed."""
        sim = self.owner.sim
        self.start_time = sim.time
        self.elapsed_time = 0.0
        self.state = SUCCEEDED
        with self.in_stack("S"):
            self.deploy_to(sim)
            if self.parent is not None:
                self.parent.child_succeeded(self)
                
    def deploy_to(self, sim):
        raise NotImplementedError()
        
