from khronos.statistics.plotter import get_plotter

class FTable(dict):
    """This class implements a simple frequency table. It may be consulted for absolute and 
    relative frequencies of values. Since it is a dictionary, care should be taken not to add
    to many different values, otherwise the size of the table will grow out of control."""
    def __init__(self):
        dict.__init__(self)
        self.__total_weight = 0.0
        
    def __repr__(self):
        return self.__class__.__name__ + dict.__repr__(self)
        
    def __call__(self):
        print self.report()
        
    def report(self):
        rep = object.__repr__(self)
        for value, freq in sorted(self.iteritems()):
            rep += "\n\t%s :: %f (%f%%)" % (value, freq, 100.0 * freq / self.__total_weight)
        return rep
        
    def clear(self):
        dict.clear(self)
        self.__total_weight = 0.0
        
    def collect(self, value, weight=1.0):
        try:
            self[value] += weight
        except KeyError:
            self[value] = weight
        self.__total_weight += weight
        
    def merge(self, ftable):
        if not isinstance(ftable, FTable):
            raise TypeError("expected FTable")
        for v, f in ftable.iteritems():
            self.add(v, f)
            
    def abs_frequency(self, value):
        return self.get(value, 0.0)
        
    def rel_frequency(self, value):
        try:
            return self.get(value, 0.0) / self.__total_weight
        except ZeroDivisionError:
            return 0.0
            
    def total(self):
        return self.__total_weight
        
    # -----------------------------------------------
    def pie_chart(self, axes=None, *args, **kwargs):
        plotter, axes = get_plotter(axes)
        return plotter.pie_chart(self.keys(), self.values(), axes=axes, *args, **kwargs)
        
    def bar_chart(self, axes=None, *args, **kwargs):
        plotter, axes = get_plotter(axes)
        return plotter.bar_chart(self.keys(), self.values(), axes=axes, *args, **kwargs)
        
    def pareto_chart(self, axes=None, *args, **kwargs):
        plotter, axes = get_plotter(axes)
        return plotter.pareto_chart(self.keys(), self.values(), axes=axes, *args, **kwargs)
        
    def histogram(self, axes=None, bins=10, *args, **kwargs):
        plotter, axes = get_plotter(axes)
        return plotter.histogram(self.keys(), self.values(), bins=bins, axes=axes, *args, **kwargs)
        
