from khronos.statistics import *
from random import Random
    
rng  = Random()
HOUR = 1.0
DAY  = 24.0 * HOUR
WEEK = 7.0 * DAY

def high():   return 40
def medium(): return 25
def low():    return 10

normal_day = TimeVaryingDistr(name="normal_day", default=low, loop=DAY)
normal_day.add(high, (8*HOUR, 10*HOUR), (18*HOUR, 20*HOUR))
normal_day.add(medium, (7*HOUR, 8*HOUR), (10*HOUR, 11*HOUR), 
                       (17*HOUR, 18*HOUR), (20*HOUR, 21*HOUR))

bad_day = TimeVaryingDistr(name="bad_day", loop=DAY)
bad_day.add(high, (8*HOUR, 9.5*HOUR), (18*HOUR, 19*HOUR))
bad_day.add(medium, (7*HOUR, 8.5*HOUR), (9*HOUR, 10*HOUR), (17*HOUR, 20*HOUR))
bad_day.add(low, (0*HOUR, 8*HOUR), (9.5*HOUR, 18*HOUR), (19*HOUR, 24*HOUR))

week = TimeVaryingDistr(name="normal_week", default=normal_day, loop=WEEK)
week.add(bad_day, (0*DAY, 1*DAY), (6*DAY, 7*DAY))

def test_week(samples=10000):
    tseries = TSeries(storing=True)
    for x in xrange(samples):
        time = x / float(samples) * WEEK
        tseries.collect(week(time), time)
    tseries.run_chart()
    
distr = TimeVaryingDistr(loop=100, transition_order=2)
distr.add(lambda: 25, (0, 50))
distr.add(lambda: 75, (30, 80))
distr.add(lambda: 30, (60, 100))

def test(samples=1000):
    tseries = TSeries(storing=True)
    for x in xrange(samples):
        time = x / float(samples) * 100.0
        tseries.collect(distr(time), time)
    tseries.run_chart()
    
##from utils import *
##from khronos.primitives import *
##from khronos.components import *
##from khronos.engine import *
##from khronos.extra.components.queueing import *
##
##class Transaction(Process.Atomic):
##    @Chain
##    def initialize(self):
##        sim = self.sim
##        while True:
##            yield sim["LB"].put_request(self, 10)
##            yield sim["AS"].put_request(self, 10)
##            yield sim["DB"].put_request(self, 10)
##            
##sim = Simulator(members=[Transaction(), 
##                         queue.PS("LB", capacity=0.25), 
##                         queue.PS("AS", capacity=1.25), 
##                         queue.PS("DB", capacity=0.25)])


# SDE TEST CODE
#def app():
#    from khronos.extra.gui.app import SimApp
#    sde = SimApp()
#    sde.widgets.menubar.widgets.file.open(filepath="../specj2004sim/testanim.py")
#    sde.mainloop()
    
## SIGNAL MANAGER TEST CODE
##from utils.signals import *
##import sys
##
##def foo(*args,**kwargs):
##    print args, kwargs
##    
##m = SignalManager()
##m.add_listener("foo", foo)
##m.add_listener("dir", dir)
##m.add_listener("quit", sys.exit)
##m.signal("foo", 1, 2, 3, four=4, five=5, six=6)

# ARENA TEST CODE
#from anim2d.arena import ArenaApp
#from anim2d import Object2D, Shape
#from math import pi
#
#o = Object2D(Shape=Shape.rect(10, 10, fill="green"))
#a = ArenaApp()
#a.add(o)
#
#def forward(event): o.move_front(10)
#def back(event): o.move_back(10)
#def left(event): o.move_left(10)
#def right(event): o.move_right(10)
#def turn_left(event): o.rotate(pi / 10)
#def turn_right(event): o.rotate(-pi / 10)
#
#o.bind("w", forward)
#o.bind("s", back)
#o.bind("a", left)
#o.bind("d", right)
#o.bind("<KeyPress-Left>", turn_left)
#o.bind("<KeyPress-Right>", turn_right)

## MORE PRIMITIVE TEST CODE
##class Foo(Process.Atomic):
##    @Chain
##    def initialize(self):
##        yield 5 * (3 >> Signal("foo") ^ Renege(Request(), Delay(2)))
##        
##sim = Simulator(members=[Foo()])
##
##class Master(Process.Compound):
##    patience = 75
##    def reset(self):
##        for x in xrange(self.slaves):
##            if x not in self:
##                self.add(Slave(x))
##                
##    @Chain
##    def initialize(self):
##        yield 0
##        sync = Signal("Master starting")
##        for slave in self:
##            sync &= Callback(slave.work(), on_succeed=Call(self.remove, slave))
##        yield Renege(~sync, Delay(self.sim.rng.randint(self.patience - 10, 
##                                                       self.patience + 10)))
##        yield Signal("Master finished")
##        
##class Slave(Process.Atomic):
##    @Chain.bound
##    def work(self):
##        yield self.sim.rng.randint(10, 100)
##        
##sim = Simulator(members=[Master(slaves=5)])

# RENEGING TEST CODE
#class sender(Process.Atomic):
#    @Chain
#    def initialize(self):
#        yield 0
#        while True:
#            yield Signal("packet")
#            yield Renege(Listener(["ack"]), Delay(10))
#            yield 1
#            
#class receiver(Process.Atomic):
#    @Chain
#    def initialize(self):
#        while True:
#            yield Listener(["packet"])
#            r = Renege(Delay(self.sim.rng.randint(5, 15)), Delay(10, priority=1.0))
#            yield r
#            if r.succeeded():
#                yield Signal("ack")
#                
#sim = Simulator(members=[sender(), receiver()])

## ANIMATION TEST CODE
##from khronos.extra.animation import *
##from utils.debugging import *
##from Tkinter import *
##from math import pi
##
##t = Tk()
##a = Arena(t)
##a.pack()
##
##class Ball(Object2D):
##    def __init__(self, *args, **kwargs):
##        Object2D.__init__(self, *args, **kwargs)
##        self.Shape = Shape.oval(50, 50, fill="blue")
##        self.speed = 10
##        
##    @debug.function
##    def setup(self):
##        self.bind("<KeyPress-Up>", self.goforward)
##        self.bind("<KeyPress-Left>", self.turnleft)
##        self.bind("<KeyPress-Right>", self.turnright)
##        self.bind("<Any-KeyPress>", self.printkey)
##        
##    def goforward(self, _):
##        self.move_front(100)
##        
##    def turnleft(self, _):
##        self.heading -= pi/10
##        
##    def turnright(self, _):
##        self.heading += pi/10
##        
##    @debug.function
##    def printkey(self, event):
##        print event.char
##        
##b = Ball(master=a)
##b.setup()

# 
#class Replicant(Process.Atomic):
#    @Chain
#    def initialize(self):
#        yield self.sim.rng.randint(0, 100)
#        self.stop()
#        self.parent = None
#        self.sim.launch(Replicant(), condition=Delay(3), who=self)
#        
#s = Simulator(members=[Replicant()])

## STATISTICS TEST CODE
##from utils.statistics import *
##
##class Clock(object):
##    def __init__(self):
##        self.value = 0
##        
##    def __call__(self):
##        t = self.value
##        self.value += 1
##        return t
##        
##class A(object):
##    x = AutoStat()
##    
##    @x.stat_constructor
##    def tseries():
##        return TSeries(storing=True, time_fnc=Clock())
##        
##    @x.stat_collector
##    def tseries_collect(self, ts, v):
##        ts.collect(v)
##        
##    def __init__(self):
##        A.x.initialize(self, 0)
##        
##a = A()
##for x in range(1, 11) + range(11, -11, -2):
##    a.x = x
##A.x[a].run_chart(ylabel="Stock value")

# SIMULATION TEST CODE
#from khronos import *
#
#class PingPong(Process.Atomic):
#    def initialize(self):
#        return Callback(Delay(10), self.ping)
#        
#    def ping(self):
#        if self.sim.time > 100:
#            print "I'm tired, let's stop playing."
#        else:
#            print "Ping"
#            return Callback(Delay(10), self.pong)
#            
#    def pong(self):
#        print "Pong"
#        return Callback(Delay(3), self.ping)
#        
#s = Simulator()
#s.start()
#s.launch(PingPong(), after=Delay(5))
#s.launch(PingPong(), after=Delay(5))
#s.run()

## PRIMITIVE TEST CODE
##class dummysim(object):
##    def get_time(self):
##        return 0
##        
##    def dispatch(self, action):
##        print "dispatching", action
##        if not isinstance(action, (Chain, Callback)):
##            action.configure(self.deploy, self.retract, self.redeploy)
##        action.start()
##        
##    def deploy(self, action):
##        print "deploying", action
##        
##    def retract(self, action):
##        print "retracting", action
##        
##    def redeploy(self, action):
##        print "redeploying", action
##        
##    def push_event(self, action):
##        print "pushing", action.state, action
##        
##    def pop_event(self):
##        print "popping action"
##        

# HIERARCHY TEST CODE
#a = [Process.Atomic(x) for x in xrange(10)]
#c = [Process.Compound(x) for x in xrange(5)]
#
#a[0].parent = c[0]
#c[0] += a[3]
#c[0] += a[7]
#c[0] += a[9]
#c[0] += c[4]
#c[4] += c[3]
#c[4] += c[1]

## SCHEDULE TEST CODE
##from khronos.primitives import *
##from khronos.engine import *
##
##d = [Delay(x) for x in "abcde"]
##
##s = Schedule()
##s.insert(d[0], 5, 0.5)
##s.insert(d[1], 5, 0.1)
##s.insert(d[2], 5, 1.1)
##s.insert(d[3], 4, 0.0)
##s.insert(d[4], 10, 99.0)

# STACK TEST CODE
#from khronos.primitives import *
#from khronos.engine import *
#
#d = [Delay(x) for x in "abcde"]
#s = Stack()
#s.push(d[0])
#s.push(d[1])
