class TextProcessor(object):
    """This class allows defining text processors with customized indentation and line breaking
    facilities."""
    def __init__(self, indent="    ", linebreak="(...)", width=100):
        self.__indent = None
        self.__indentation = None
        self.__linebreak = None
        self.__width = None
        self.set_indent(indent)
        self.set_linebreak(linebreak)
        self.set_width(width)
        
    def set_indent(self, indent):
        self.__indent = indent
        self.__indentation = [indent * x for x in xrange(50)]
        
    def set_linebreak(self, linebreak="(...)"):
        self.__linebreak = linebreak
        
    def set_width(self, width):
        self.__width = width
        
    def indentation(self, n=1):
        return self.__indent * n if n >= 50 else self.__indentation[n]
        
    def indent_line(self, line, n=1):
        return self.indentation(n) + line
        
    def indent(self, text, n=1):
        ind = self.indentation(n)
        nl = "\n" + ind
        return ind + text.replace("\n", nl)
        
    def fit_line(self, line, width=None):
        if width is None:
            width = self.__width
        if width is None or len(line) <= width:
            return line
        if width <= len(self.__linebreak):
            return line[:width]
        return line[:width - len(self.__linebreak)] + self.__linebreak
        
    def fit(self, text, width=None):
        if width is None:
            width = self.__width
        return "\n".join(self.fit_line(line, width) for line in text.splitlines())
        
    def rfit_line(self, line, width=None):
        if width is None:
            width = self.__width
        if width is None or len(line) <= width:
            return line
        if width <= len(self.__linebreak):
            return line[-width:]
        return self.__linebreak + line[-width + len(self.__linebreak):]
        
    def rfit(self, text, width=None):
        if width is None:
            width = self.__width
        return "\n".join(self.rfit_line(line, width) for line in text.splitlines())
        
