from os import path, listdir

def full_package_list(directory, package_name=None):
    directory = path.abspath(directory)
    if not path.isdir(directory):
        raise ValueError("%s is not a directory" % (directory,))
    if package_name is None:
        package_name = path.basename(directory)
    else:
        package_name = package_name + "." + path.basename(directory)
        
    #print "listing packages in ", directory
    packages = []
    init = path.join(directory, "__init__.py")
    if path.exists(init) and path.isfile(init):
        packages.append(package_name)
        #print "found package", package_name
        for entry in listdir(directory):
            target = path.join(directory, entry)
            if path.isdir(target):
                packages.extend(full_package_list(target, package_name))
    return packages
    
if __name__ == "__main__":
    from distutils.core import setup
    import khronos
    
    with open('README.txt') as readme:
        long_description = readme.read()
    
    setup(
        name="Khronos", 
        version=khronos.__version__, 
        author=khronos.__author__ , 
        author_email=khronos.__author_email__, 
        url=khronos.__url__, 
        license=khronos.__license__, 
        description="A collection of libraries for simulation, optimization, and much more!", 
        long_description=long_description,
        packages=full_package_list("./khronos")
    )
