'''
Widgets
=======

A widget is an element of a graphical user interface.
The `kivy.uix` module contains classes for creating and managing Widgets.

Read first: :doc:`api-kivy.uix.widget`

- **UX widgets**: Classical user interface widgets, perfect and ready to be
  assembled to create more complex widgets.

    :doc:`api-kivy.uix.label`, :doc:`api-kivy.uix.button`,
    :doc:`api-kivy.uix.image`, :doc:`api-kivy.uix.slider`,
    :doc:`api-kivy.uix.progressbar`, :doc:`api-kivy.uix.textinput`,
    :doc:`api-kivy.uix.togglebutton`, :doc:`api-kivy.uix.switch`,
    :doc:`api-kivy.uix.video`

- **Layouts**: A layout widget has no rendering, just a trigger
  that will arrange its children in a specific way. Read more on
  :doc:`api-kivy.uix.layout`

    :doc:`api-kivy.uix.gridlayout`, :doc:`api-kivy.uix.boxlayout`,
    :doc:`api-kivy.uix.anchorlayout`, :doc:`api-kivy.uix.stacklayout`

- **Complex UX widgets**: Non-atomic widgets, result of classic widget
  combinations. We call them complex because the assembly and usages are not as
  generic as the classicals widgets.

    :doc:`api-kivy.uix.bubble`,
    :doc:`api-kivy.uix.filechooser`, :doc:`api-kivy.uix.popup`,
    :doc:`api-kivy.uix.videoplayer`,
    :doc:`api-kivy.uix.vkeyboard`

- **Behaviors widgets**: Theses widgets have no rendering, but act on the graphics
  part, or even on the interaction (touch) part.

    :doc:`api-kivy.uix.scatter`, :doc:`api-kivy.uix.stencilview`

----
'''
