var format = function (str, col) {
    col = typeof col === 'object' ? col : Array.prototype.slice.call(arguments, 1);

    return str.replace(/\{([^}]+)\}/gm, function () {
        return col[arguments[1]];
    });
};

var url_to_active_processor_list = null;
var url_to_processor_status = null;

function status_for_processor(user, app_label, item_type, item_id)
{
    console.log(format("Querying processor status for user \"{0}\", item_type \"{1}\", item_id \"{2}\"",
                    user, item_type, item_id));
    
    if (url_to_processor_status != null)
    {
        var params = {
            'user': user,
            'item_type': item_type,
            'item_id': item_id,
            'app_label': app_label
        };
        
        $.getJSON(url_to_processor_status, params, function(result) {
            $.each(result, function(index, item){
                var selector = format("#{0}_status", item['processor_identifier']);
                $(selector).html(item['status']);
                selector = format("#{0}_log_count", item['processor_identifier']);
                $(selector).html(item['log_count']);
            });
        });
    }
    
    return false;
}

function update_active_processors()
{
    console.log("Refreshing processor list");
    console.log(url_to_active_processor_list);
    if (url_to_active_processor_list != null)
    {
        var data = {'user': '{{ user }}'};
        $.getJSON(url_to_active_processor_list, data, function(data) {
            $('.row1').remove();
            $('.row2').remove();
            for (var i=0; i < data.length; i++) {
                var rowclass = i % 2 == 0 ? "row1" : "row2";
                var item = data[i];
                var new_row = format("<tr class='{0}'><td><a href='{1}'>{2}</a></td><td>{3}</td><td>{4}</td><td><a href='{5}'>{6}</a></td></tr>",
                                rowclass, item['process_item_link'], item['owner'], item['processor_identifier'],
                                item['duration'], item["content_link"], item["item_text"]);
                $('#result_items').append(new_row);
             }
        });
    }
}

function update_active_processors_timer()
{
    console.log("Starting timer");
    setInterval(update_active_processors, 10000);
}

$(document).ready(function() {

    $('#spinner').hide();
    $('#kolibri_options').hide();

    $( document ).ajaxStart( function() {
        $( '#spinner' ).show();
    }).ajaxStop( function() {
        $( '#spinner' ).hide();
    });

    $('#kolibri_check').click(function() {
        if (url_to_active_processor_list != null)
        {
            var data = {'user': current_user};
            $.getJSON(url_to_active_processor_list, data, function(data) {
                alert(data);
                $('#proc_id_4_status').html("ok");
            });
        }
        return false;
    });

    $('#kolibri_options_toggle').click(function() {
        $('#kolibri_options_toggle').html("<b>Available processors and workflows:</b>");
        $('#kolibri_options').toggle(400);
        return false;
      });

    $('div.proc_details> table').hide();
    $('div.proc_details> h4').click(function() {
        var $nextDiv = $(this).next();
        var $visibleSiblings = $nextDiv.siblings('div:visible');

    if ($visibleSiblings.length ) {
        $visibleSiblings.slideUp('fast', function() {
            $nextDiv.slideToggle('fast');
        });
    } else {
        $nextDiv.slideToggle('fast');
    }
    });

});
