

class Step(object):
    """

    """

    def __init__(self, workflow, processor=None, on_exception=None, ignore_exception=False):
        """

        """
        self.workflow = workflow
        self.processor = processor
        self.ignore_exception = ignore_exception
        self._on_exception = []
        if on_exception:
            for ex, proc in on_exception:
                self.on_exception(ex, proc)

    def __unicode__(self):
        """

        """
        return "Workflow: %s. Step: %s." % (self.workflow.title, self.processor.text)

    def __repr__(self):
        """

        """
        return self.__unicode__()

    def then(self, processor):
        """

        """
        return self.workflow.add(processor)

    def on_exception(self, ex, processor):
        """

        """
        self.workflow.validate_processor(processor)
        s = Step(self.workflow, processor)
        self._on_exception.append((ex, s))
        return self

    def and_finally(self, processor):
        """

        """
        return self.workflow.and_finally(processor)

    def exceptions(self):
        """

        """
        return [("%s.%s" % (e.__module__, e.__name__),p) for e,p in self._on_exception]