from kolibri.core import *
from step import Step


class Workflow(object):
    """

    """
    title = None
    description = None
    model = None

    def __init__(self, title, user_exclusive=False, model=None, *args, **kwargs):
        """

        """
        self.title = title
        self.user_exclusive = user_exclusive
        self._steps = []
        self._and_finally = None
        self.model = model
        self.args = args
        self.kwargs = kwargs

    def identifier(self):
        """

        """
        return  name_from_item(self)

    def validate_processor(self, processor):
        """

        """
        assert isinstance(processor, Processor), \
            "Expected processor to be instance of Processor. Got %s." % type(processor)

        if self.user_exclusive and not processor.user_exclusive:
            raise WorkflowIsUserExlcusive(
                "Workflow %s is user-exclusive and can only use processors that are user-exclusive. Processor %s is not." %\
                (self.title, processor))

    def first(self, processor, on_exception=None):
        """

        """
        self.validate_processor(processor)
        return self.add(processor, on_exception)

    def add(self, processor, on_exception=None):
        """

        """
        self.validate_processor(processor)
        s = Step(self, processor, on_exception)
        self._steps.append(s)
        return s

    def and_finally(self, processor):
        """

        """
        self.validate_processor(processor)
        self._and_finally = Step(self, processor)

    @property
    def steps(self):
        """

        """
        if self._and_finally:
            return self._steps + [self._and_finally]
        return self._steps

    def __len__(self):
        """

        """
        return len(self.steps)
    

    def __iter__(self):
        """
        
        """
        for step in self._steps:
            yield step

    def __getitem__(self, item):
        """

        """
        return self.steps[item]

    def processors(self):
        """

        """
        result = []
        for step in self.steps:
            result.append(step.processor)
            for ex, inner_step in step._on_exception:
                if not inner_step.processor in result:
                    result.append(inner_step.processor)
        return result

    @property
    def implements_process(self):
        """
        At least one of the related processors implements the process method.
        """
        for step in self.steps:
            if step.processor.implements_process:
                return True
            
