import datetime
import json

from django.contrib.auth.models import User
from django.contrib.auth.decorators import login_required
from django.contrib.contenttypes.models import ContentType
from django.http import HttpResponse
from django.shortcuts import redirect
from django.core.urlresolvers import reverse

from kolibri.models import ProcessItem, ProcessResultDict
from kolibri.core import manager

dthandler = lambda obj: obj.isoformat() if isinstance(obj, datetime.datetime) else None

def active_processes(request):
    if request.is_ajax():
        try:
            import time
            time.sleep(2)
            result = []
            for item in ProcessItem.objects.filter(finished__isnull=True)[:25]:
                result.append({
                    'process_item_link': reverse('admin:kolibri_processitem_change', args=[item.id]),
                    'duration': item.started and str(datetime.datetime.today() - item.started).split('.')[0] or 'Not started',
                    'started': item.started and item.started or 'Not started',
                    'owner': str(item.owner),
                    'processor_identifier': item.processor_identifier,
                    'status':ProcessResultDict.get(item.result),
                    'content_link': item.item and item.get_admin_link() or '',
                    'item_text': item.item and str(item.item) or ''
                    })
            return HttpResponse(json.dumps(result, default=dthandler), mimetype="application/json")
        except Exception, e:
            print e
    return HttpResponse("This is a ajax view.")


def processor_status(request):
    if 1:#if request.is_ajax():
        if 1:#try:
            user = User.objects.get(username=request.GET.get('user'))
            item_type = request.GET.get('item_type')
            item_id = request.GET.get('item_id')
            app_label = request.GET.get('app_label')
            result = []
            item_count_per_processor = {}
            if item_type and app_label:
                model_type = ContentType.objects.get(app_label=app_label, model=item_type.lower())
                if item_id != "None" and item_id:
                    model_instance = model_type.get_object_for_this_type(id=int(item_id))
                    processors = manager.status.processors_for_instance(model_instance)
                    item_count_per_processor = ProcessItem.count_for_instance(model_instance)
                else:
                    processors = manager.status.processors_for_model(user, model_type.model_class())
                    item_count_per_processor = ProcessItem.count_for_model(model_type.model_class())
            else:
                processors = manager.status.processors_for_user(user)

            found = []
            for item in processors:
                if not item:
                    continue
                    
                result.append(
                        {'processor_identifier': item.identifier(),
                         'status': 'Pending',
                         'log_count': item_count_per_processor.get(item.identifier(), 0)
                    })
                found.append(item.identifier())

            for processor_identifier in [proc for proc in manager.processor.identifiers() if proc not in found]:
                result.append(
                        {'processor_identifier': processor_identifier,
                         'status': 'Free',
                         'log_count': item_count_per_processor.get(processor_identifier, 0)
                    })

            for workflow in manager.workflow.values():
                handled = False
                for processor in found:
                    if processor in [proc.identifier() for proc in workflow.processors()]:
                        result.append({'processor_identifier': workflow.identifier(), 'status': 'Pending', 'log_count': 'N/A'})
                        handled = True
                if not handled:
                    result.append({'processor_identifier': workflow.identifier(), 'status': 'Free', 'log_count': 'N/A'})

            return HttpResponse(json.dumps(result), mimetype="application/json")
        #except Exception, e:
        #    raise e
    return HttpResponse("This is a ajax view.")


def internal_execute_processor(instance_pks, model_name, request, selected_processors, selected_workflows, execution_mode=False):
    """
    
    """
    if execution_mode:
        if selected_processors:
            manager.execute.processor.base(request.user, selected_processors[0])
        return

    model_instances = []

    processors = []
    for proc in selected_processors:
        for p in manager.processor.values():
            if p.identifier() == proc and p.model.__name__ == model_name:
                if not model_instances:
                    model_instances = p.model.objects.filter(id__in=instance_pks)
                processors.append(p.identifier())

    workflows = []
    for workflow_identifier in selected_workflows:
        for workflow in manager.workflow.values():
            if workflow.identifier() == workflow_identifier and workflow.model.__name__ == model_name:
                if not model_instances:
                    model_instances = workflow.model.objects.filter(id__in=instance_pks)
                workflows.append(workflow_identifier)

    if model_instances and processors:
        manager.execute.processor.many_processors(request.user, processors, model_instances)

    if model_instances and workflows:
        for workflow in workflows:
            manager.execute.workflow.many(request.user, workflow, model_instances)


@login_required
def execute_processor(request):
    """

    """
    selected_processors = [v for k,v in request.POST.items() if 'proc_id_' in k]
    instance_pks = [int(v) for k,v in request.POST.items() if 'pk_id_' in k]
    selected_workflows = [v for k,v in request.POST.items() if 'wf_id_' in k]
    model_name = request.POST.get('model_name')
    internal_execute_processor(instance_pks, model_name, request, selected_processors, selected_workflows, request.POST.get('execution_mode') != None)

    return redirect(request.META.get('HTTP_REFERER'))
