from kolibri.models import *
from kolibri.core.admin import Admin
from kolibri.core.status import StatusHandler
from kolibri.core.execution import *
from kolibri.core import name_from_item
from django.core.cache import cache
from django.utils.hashcompat import md5_constructor as md5

def generate_lock_id(owner, global_process, processor_identifier, item=None):
    """
    http://celeryq.org/docs/cookbook/tasks.html
    """
    result = []
    if not global_process:
        result.append(owner.username)
    result.append(processor_identifier)

    if item:
        if hasattr(item, '_meta'):
            result.append("%s-%s-%s" % (item._meta.app_label, item._meta.module_name, item.id))
        else:
            result.append(name_from_item(item))

    return "kolibri-lock-%s" % md5('.'.join(result)).hexdigest()


def lock_exists(lock_id):
    """

    """
    return cache.get(lock_id) is not None


class ProcessRegistration(object):
    """

    """
    def __init__(self, context):
        """

        """
        self.context = context

    def add_process(self, user, text=None):
        """

        """
        return Process.start(user, text)

    def add_process_item(self, parent, processor_identifier, item, and_finally=False):
        """

        """
        return item and ProcessItem.process_item(parent, processor_identifier, item, and_finally) or \
               ProcessItem.execute(parent, processor_identifier)

    def add_process_exception(self, process_item, processor_identifier, exception_name):
        """

        """
        return ProcessException.on_exception(process_item, processor_identifier, exception_name)



class InternalRegistration(object):
    """

    """

    def __init__(self, context):
        """

        """
        self.context = context

    def workflow(self, workflow):
        """

        """
        self.context.workflow.register(workflow)

    def processor(self, processor):
        """

        """
        self.context.processor.register(processor)


class WorkflowRegistration(object):
    """

    """

    def register(self, item):
        """

        """
        Context.register_workflow(item)

    def __getitem__(self, item):
        """

        """
        return Context._workflows.get(item)

    def identifiers(self):
        """

        """
        return Context._workflows.keys()

    def model_identifiers(self):
        """

        """
        return Context._workflows_for_model.keys()

    def get_by_model(self, model, user=None):
        """

        """
        result = []
               
        for p in Context._workflows_for_model.get(name_from_item(model), []):
            if not p.implements_process:
                continue

            if not user or (user and user.is_staff):
                result.append(p)

        return result

    def values(self):
        """

        """
        return Context._workflows.values()


class ProcessorRegistration(object):
    """

    """

    def register(self, item):
        """

        """
        Context.register_processor(item)

    def __getitem__(self, item):
        """

        """
        return Context._processors.get(item)

    def identifiers(self):
        """

        """
        return Context._processors.keys()

    def model_identifiers(self):
        """

        """
        return Context._processors_for_model.keys()

    def get_by_model(self, model, user=None):
        """

        """
        result = []
        for p in Context._processors_for_model.get(name_from_item(model), []):
            if not p.implements_process:
                continue

            if not user or (user and user.is_staff):
                result.append(p)

        return result

    def values(self):
        """

        """
        return Context._processors.values()


class Context(object):
    """

    """
    _processors = {}
    _workflows = {}
    _processors_for_model = {}
    _workflows_for_model = {}

    def __init__(self, async=True, *args, **kwargs):
        """

        """
        self.async = async
        self.args = args
        self.kwargs = kwargs
        
        self.processor = ProcessorRegistration()
        self.workflow = WorkflowRegistration()
        self.process_registration = ProcessRegistration(self)
        self.status = StatusHandler(self)
        self.execute = Execution(self)
        self.register = InternalRegistration(self)
        self.admin = Admin(self)

    @classmethod
    def reset(cls):
        """

        """
        cls._processors = {}
        cls._workflows = {}
        cls._processor_for_model = {}
        cls._workflow_for_models = {}

    @classmethod
    def register_processor(cls, processor):
        """

        """
        if not processor.identifier() in cls._processors:
            cls._processors[processor.identifier()] = processor

        if processor.model:
            instance_name = name_from_item(processor.model)
            if not instance_name in cls._processors_for_model:
                cls._processors_for_model[instance_name] = []
            cls._processors_for_model[instance_name].append(processor)

    @classmethod
    def register_workflow(cls, workflow):
        """

        """
        if not workflow.identifier() in cls._workflows:
            cls._workflows[workflow.identifier()] = workflow

        if workflow.model:
            instance_name = name_from_item(workflow.model)
            if not instance_name in cls._workflows_for_model:
                cls._workflows_for_model[instance_name] = []
            cls._workflows_for_model[instance_name].append(workflow)
