from kolibri.core import WorkflowNotFound, ProcessorNotFound, name_from_item


class ExecutionBase(object):
    """

    """

    def __init__(self, parent):
        """

        """
        self.parent = parent
        self.registration = self.parent.context.process_registration


    def execute(self, process, **kwargs):
        """

        """
        from kolibri.tasks import executor
        if self.parent.context.async:
            executor.delay(process, **kwargs)
        else:
            executor(process, **kwargs)
        
class WorkflowExecution(ExecutionBase):
    """

    """

    def _do_the_steps(self, process, workflow, item=None, **kwargs):
        """

        """
        for step in workflow.steps:
            process_item = self.registration.add_process_item(process, name_from_item(step.processor), item, and_finally=step==workflow._and_finally)
            for exc, step in step._on_exception:
                self.registration.add_process_exception(process_item, step.processor.identifier(), name_from_item(exc))

        process.save()

    def _get_workflow(self, workflow_identifier):
        """

        """
        workflow = self.parent.context.workflow[workflow_identifier]
        if not workflow:
            raise WorkflowNotFound(workflow_identifer)
        return workflow

    def one(self, user, workflow_identifier, item, **kwargs):
        """

        """
        process = self.parent.context.process_registration.add_process(user)
        process.workflow = workflow_identifier
        workflow = self._get_workflow(workflow_identifier)
        self._do_the_steps(process, workflow, item, **kwargs)
        self.execute(process, **kwargs)

    def many(self, user, workflow_identifier, iterable, **kwargs):
        """

        """
        process = self.parent.context.process_registration.add_process(user)
        process.workflow = workflow_identifier
        workflow = self._get_workflow(workflow_identifier)
        for item in iterable:
            self._do_the_steps(process, workflow, item, **kwargs)
        self.execute(process, **kwargs)

    def queryset(self, user, workflow_identifier, qs, **kwargs):
        """

        """
        process = self.parent.context.process_registration.add_process(user)
        process.workflow = workflow_identifier
        workflow = self._get_workflow(workflow_identifier)
        for item in qs:
            self._do_the_steps(process, workflow, item, **kwargs)
        self.execute(process, **kwargs)

    def base(self, user, workflow_identifier, **kwargs):
        """

        """
        process = self.parent.context.process_registration.add_process(user)
        process.workflow = workflow_identifier
        workflow = self._get_workflow(workflow_identifier)
        self._do_the_steps(process, workflow, None, **kwargs)
        self.execute(process, **kwargs)


class ProcessorExecution(ExecutionBase):
    """

    """

    def _get_processor(self, processor_identifier):
        """

        """
        processor = self.parent.context.processor[processor_identifier]
        if not processor:
            raise ProcessorNotFound(processor_identifier)
        return processor

    def one(self, user, processor_identifier, item, **kwargs):
        """

        """
        process = self.parent.context.process_registration.add_process(user)
        self.parent.context.process_registration.add_process_item(process, processor_identifier, item)
        self.execute(process, **kwargs)

    def many(self, user, processor_identifier, iterable, **kwargs):
        """

        """
        process = self.parent.context.process_registration.add_process(user)
        for item in iterable:
            self.parent.context.process_registration.add_process_item(process, processor_identifier, item)
        self.execute(process, **kwargs)

    def base(self, user, processor_identifier, **kwargs):
        """

        """
        process = self.parent.context.process_registration.add_process(user)
        self.parent.context.process_registration.add_process_item(process, processor_identifier, None)
        self.execute(process, **kwargs)

    def many_processors(self, user, processor_identifiers, iterable, **kwargs):
        """

        """
        process = self.parent.context.process_registration.add_process(user)
        for processor_identifier in processor_identifiers:
            for item in iterable:
                self.parent.context.process_registration.add_process_item(process, processor_identifier, item)
        self.execute(process, **kwargs)

class Execution(object):
    """
    
    """

    def __init__(self, context, debug=True):
        """

        """
        self.debug = debug
        self.context = context
        self.workflow = WorkflowExecution(self)
        self.processor = ProcessorExecution(self)

