#/usr/bin/env python

from setuptools import setup, find_packages

setup(
    name = "Kolibri",
    version = "0.1.1",
    author = "Thomas Weholt",
    author_email = "thomas@weholt.org",
    description = "Asynchronous Processors/Workflow management for django.",
    license = "Modified BSD",
    url = "http://bitbucket.org/weholt/django-kolibri",
    keywords = "django celery asynchronous processing workflow",
    long_description="%s\n\n%s" % (open('README.txt').read(), open('usage.txt').read()),
    install_requires = [
            "django",
            "celery",
            "django-celery"
    ],
    packages = ['kolibri'],
    package_data = {
        'kolibri': [
            'templates/kolibri/*.html',
            'templates/kolibri/admin/*.html',
            'templates/admin/*.html',
            'templates/admin/kolibri/*.html',
            'templates/*.html',
        ]
    },
    zip_safe = False,
    classifiers = ["Development Status :: 2 - Pre-Alpha",
                   'Environment :: Web Environment',
                   'Framework :: Django',
                   'Intended Audience :: Developers',
                   'License :: OSI Approved :: BSD License',
                   'Operating System :: OS Independent',
                   'Programming Language :: Python',
                   'Topic :: Utilities'],
)
