from kolibri.models import *

class StatusHandler(object):
    """

    """

    def __init__(self, context):
        """

        """
        self.context = context

    def processes_for_user(self, user):
        """

        """
        qs = Process.objects.filter(owner=user, finished__isnull=True)
        return self._return_processors(qs)

    def processors_for_user(self, user):
        """

        """
        result = []
        for item in ProcessItem.objects.filter(finished__isnull=True, content_type__isnull=True):
            processor = self.context.processor[item.processor_identifier]
            if not processor.user_exclusive or (processor.user_exclusive and item.owner == user):
                result.append(processor)
        return result

    def processors_for_model(self, user, model):
        """
        Used to find processors status for a given mode, like in the admin actions.
        """
        model_type = ContentType.objects.get_for_model(model)
        result = []
        for item in ProcessItem.objects.filter(finished__isnull=True):
            processor = self.context.processor[item.processor_identifier]
            if not processor or not model_type or processor.model != model_type.model_class():
                continue

            if not processor.user_exclusive or (processor.user_exclusive and item.owner == user):
                result.append(processor)
        return result

    def processors_for_instance(self, instance):
        """
        Used to find processors status for a give instance, like in a details page for an instance.
        """
        instance_type = ContentType.objects.get_for_model(instance)
        result = []
        for item in ProcessItem.objects.filter(finished__isnull=True, content_type__pk=instance_type.id, object_id=instance.id):
            processor = self.context.processor[item.processor_identifier]
            if not processor in result:
                result.append(processor)
        return result
