from django.contrib import admin
from kolibri.models import *

class ProcessAdmin(admin.ModelAdmin):
    fields = ('owner', 'text', 'started', 'finished', 'result', 'global_process',)
    list_display = ('owner', 'text', 'workflow', 'registration_date', 'started', 'finished', 'result', 'global_process','details_link',)
    list_filter = ('owner', 'result', 'global_process',)

admin.site.register(Process, ProcessAdmin)

class ProcessItemAdmin(admin.ModelAdmin):
    fields = ('owner', 'parent', 'processor_identifier', 'text', 'content_type', 'result', 'started', 'finished', 'and_finally', 'sort_order',)
    list_display = ('id', 'processor_identifier', 'owner', 'content_link', 'result', 'started', 'finished', 'and_finally', 'sort_order',)
    list_filter = ('owner', 'processor_identifier', 'content_type', 'result', )

    valid_lookups = ()
    def lookup_allowed(self, lookup, *args, **kwargs):
        """
        http://stackoverflow.com/questions/6138932/master-detail-using-the-admin-in-django
        """
        if lookup.startswith(self.valid_lookups):
            return True
        return super(ProcessItemAdmin, self).lookup_allowed(lookup, *args, **kwargs)

admin.site.register(ProcessItem, ProcessItemAdmin)

class ProcessExceptionAdmin(admin.ModelAdmin):
    fields = ('process_item', 'processor_identifier', 'exception_name', )
    list_display = ('parent_processor_identifier', 'processor_identifier', 'exception_name', )
    list_filter = ('processor_identifier', 'exception_name', )

#admin.site.register(ProcessException, ProcessExceptionAdmin)
