

class LoggingContext(object):
    """

    """
    _observers = []

    @classmethod
    def register(cls, logger):
        """

        """
        if logger not in cls._observers:
            cls._observers.append(logger)

    @classmethod
    def unregister(cls, logger):
        """
        
        """
        if logger in cls._observers:
            cls._observers.remove(logger)

    @classmethod
    def log(cls, user, text, *args, **kwargs):
        """

        """
        for observer in cls._observers:
            if hasattr(observer, 'log'):
                observer.log(user, text, *args, **kwargs)

    @classmethod
    def log_status(cls, user, text, status, *args, **kwargs):
        """

        """
        for observer in cls._observers:
            if hasattr(observer, 'log_status'):
                observer.log_status(user, text, status, *args, **kwargs)

    @classmethod
    def log_instance(cls, user, text, instance, **kwargs):
        """

        """
        for observer in cls._observers:
            if hasattr(observer, 'log_instance'):
                observer.log_instance(user, text, instance, **kwargs)

    @classmethod
    def log_exception(cls, user, text, e, *args, **kwargs):
        """

        """
        for observer in cls._observers:
            if hasattr(observer, 'log_exception'):
                observer.log_exception(user, text, e, *args, **kwargs)

    @classmethod
    def warn(cls, user, text, *args, **kwargs):
        """

        """
        for observer in cls._observers:
            if hasattr(observer, 'warn'):
                observer.warn(user, text, *args, **kwargs)

    @classmethod
    def info(cls, user, text, *args, **kwargs):
        """

        """
        for observer in cls._observers:
            if hasattr(observer, 'info'):
                observer.info(user, text, *args, **kwargs)

    @classmethod
    def debug(cls, user, text, *args, **kwargs):
        """

        """
        for observer in cls._observers:
            if hasattr(observer, 'debug'):
                observer.debug(user, text, *args, **kwargs)

    @classmethod
    def critical(cls, user, text, *args, **kwargs):
        """

        """
        for observer in cls._observers:
            if hasattr(observer, 'critical'):
                observer.critical(user, text, *args, **kwargs)
