from django.conf import settings
from django.template import TemplateSyntaxError, Node, Variable
from django.template.context import Context as render_context
from kolibri.core import manager
from django import template
from kolibri.models import ProcessItem

register = template.Library()


def get_processor_data_for_form(model, user):
    result = {'processors': []}
    counter = 0
    for proc in manager.processor.get_by_model(model, user):
        result['processors'].append(
                {'id': "proc_id_%s" % counter,
                 'identifier': proc.identifier().replace('.', '_'),
                 'text': proc.text}
        )
        counter += 1
    return result


def get_workflow_data_for_form(model, user):
    result = {'workflows': []}
    counter = 0
    for workflow in manager.workflow.get_by_model(model, user):
        result['workflows'].append(
                {'id': "wf_id_%s" % counter,
                 'identifier': workflow.identifier().replace('.', '_'),
                 'text': workflow.title}
        )
        counter += 1
    return result


def kolibri_tag_data(user, instance):
    """

    """
    result = {'processors': [], 'workflows': []}
    if hasattr(instance, '_meta'):
        model = instance
    elif hasattr(instance, 'model'):
        model = instance.model
    elif hasattr(instance, '__getitem__') and hasattr(instance[0], '_meta'):
        model = instance[0]
    else:
        raise Exception(
            "Expected param instance to be model, queryset or pagination object with model instances. Got %s instead." % type(
                instance))

    result.update(get_processor_data_for_form(model, user))
    result.update(get_workflow_data_for_form(model, user))

    result['model_name'] = model._meta.object_name
    result['app_label'] = model._meta.app_label
    result['pk_id_'] = hasattr(instance, 'id') and instance.id or None
    result['csrf_token'] = None
    result['STATIC_URL'] = settings.STATIC_URL
    result['user'] = user
    return result


@register.inclusion_tag('kolibri/app_index_tag.html', takes_context = True)
def kolibri_index(context):
    return {
        'results':ProcessItem.objects.filter(finished__isnull=True),
        'current_user': context['user'],
        'available_processors': manager.processor.values(),
        'available_workflows': manager.workflow.values(),
        'in_admin': False
    }

@register.inclusion_tag('kolibri/app_index_tag.html', takes_context = True)
def kolibri_index_admin(context):
    return {
        'results':ProcessItem.objects.filter(finished__isnull=True),
        'current_user': context['user'],
        'available_processors': manager.processor.values(),
        'available_workflows': manager.workflow.values(),
        'in_admin': True
    }

@register.inclusion_tag('kolibri/kolibri_imports.html', takes_context = True)
def kolibri_imports(context):
    return {
        'current_user': context['user'],
        'STATIC_URL': settings.STATIC_URL
    }

@register.tag(name='kolibrify')
def kolibrify(parser, token):
    """

    """
    kolibri_template = None
    custom_template = None
    try:
        params = token.split_contents()
        tagname = params[0]
        if (len(params[1:]) == 1):
            model_inst = params[1]
        elif (len(params[1:]) == 2):
            model_inst, custom_template = params[1:]
        elif (len(params[1:]) == 3):
            model_inst, custom_template, kolibri_template = params[1:]
        else:
            raise ValueError("Excepted one, two or three arguments, but got %s (was: %s)." % (len(params[1:], params)))
    except ValueError:
        raise template.TemplateSyntaxError, "%r tag requires exactly two or three argument" % tagname

    return KolibriNode(custom_template, model_inst, kolibri_template, False)

@register.tag(name='kolibrify_admin')
def kolibrify_admin(parser, token):
    """

    """
    kolibri_template = None
    custom_template = None
    try:
        params = token.split_contents()
        tagname = params[0]
        if (len(params[1:]) == 1):
            model_inst = params[1]
        elif (len(params[1:]) == 2):
            model_inst, custom_template = params[1:]
        elif (len(params[1:]) == 3):
            model_inst, custom_template, kolibri_template = params[1:]
        else:
            raise ValueError("Excepted one, two or three arguments, but got %s (was: %s)." % (len(params[1:], params)))
    except ValueError:
        raise template.TemplateSyntaxError, "%r tag requires exactly two or three argument" % tagname

    return KolibriNode(custom_template, model_inst, kolibri_template, True)


class KolibriNode(template.Node):
    """

    """

    def __init__(self, custom_template, model_inst, kolibri_template, in_admin=False):
        """

        """
        self.custom_template = custom_template and custom_template.replace("'", "").replace('"', '') or None
        self.kolibri_template = kolibri_template and kolibri_template.replace("'", "").replace('"',
                                                                                               '') or 'kolibri/action_list_default.html'
        self.model_inst = template.Variable(model_inst)
        self.in_admin = in_admin

    def render(self, context):
        """

        """
        try:
            p = self.model_inst.resolve(context)
            user = context['user']
            data = kolibri_tag_data(user, p)

            if self.custom_template:
                item_formatting_template = template.loader.get_template(self.custom_template)
                data['item_formatting'] = item_formatting_template.render(
                    render_context({'object_list': p}, autoescape=context.autoescape))
            else:
                data['item_formatting'] = ''

            main_template = template.loader.get_template(self.kolibri_template)
            data['csrf_token'] = context.get('csrf_token', '')
            data['is_staff'] = user.is_staff
            data['in_admin'] = self.in_admin and 'true' or 'false'

            return main_template.render(render_context(data))
        except template.VariableDoesNotExist:
            return ''
        except Exception, e:
            return "Exception %s raised." % e

@register.tag(name='execute_kolibri')
def execute_kolibri(parser, token):
    """

    """
    custom_template = None
    try:
        params = token.split_contents()
        tagname = params[0]
        if (len(params[1:]) == 1):
            proc = params[1]
        elif (len(params[1:]) == 2):
            proc, custom_template = params[1:]
        else:
            raise ValueError("Excepted one, two or three arguments, but got %s (was: %s)." % (len(params[1:], params)))
    except ValueError:
        raise template.TemplateSyntaxError, "%r tag requires exactly two or three argument" % tagname

    return ExecuteKolibriNode(proc, custom_template, False)

@register.tag(name='execute_kolibri_admin')
def execute_kolibri_admin(parser, token):
    """

    """
    custom_template = None
    try:
        params = token.split_contents()
        tagname = params[0]
        if (len(params[1:]) == 1):
            proc = params[1]
        elif (len(params[1:]) == 2):
            proc, custom_template = params[1:]
        else:
            raise ValueError("Excepted one, two or three arguments, but got %s (was: %s)." % (len(params[1:], params)))
    except ValueError:
        raise template.TemplateSyntaxError, "%r tag requires exactly two or three argument" % tagname

    return ExecuteKolibriNode(proc, custom_template, True)


class ExecuteKolibriNode(template.Node):
    """

    """

    def __init__(self, proc, custom_template, in_admin=False):
        """

        """
        self.custom_template = custom_template and custom_template.replace("'", "").replace('"', '') or \
                               'kolibri/execute_kolibri_default.html'
        self.proc = template.Variable(proc)
        self.in_admin = in_admin

    def render(self, context):
        """

        """
        if 1:#try:
            p = self.proc.resolve(context)
            if not p.implements_execute:
                return ''

            user = context.get('user')
            data = kolibri_tag_data(user, p)
            data['proc'] = p
            data['STATIC_URL'] = settings.STATIC_URL
            data['in_admin'] = self.in_admin and 'true' or 'false'
            t = template.loader.get_template(self.custom_template)
            data['csrf_token'] = context.get('csrf_token', '')
            return t.render(render_context(data))
        #except template.VariableDoesNotExist:
        #    return ''
        #except Exception, e:
        #    return "Exception raised: %s." % e


#http://stackoverflow.com/questions/433162/can-i-access-constants-in-settings-py-from-templates-in-django
@register.tag
def value_from_settings(parser, token):
    bits = token.split_contents()
    if len(bits) < 2:
        raise TemplateSyntaxError("'%s' takes at least one argument (settings constant to retrieve)" % bits[0])
    settingsvar = bits[1]
    settingsvar = settingsvar[1:-1] if settingsvar[0] == '"' else settingsvar
    asvar = None
    bits = bits[2:]
    if len(bits) >= 2 and bits[-2] == 'as':
        asvar = bits[-1]
        bits = bits[:-2]
        if len(bits):
            raise TemplateSyntaxError("'value_from_settings' didn't recognise the arguments '%s'" % ", ".join(bits))
    return ValueFromSettings(settingsvar, asvar)


class ValueFromSettings(Node):
    
    def __init__(self, settingsvar, asvar):
        self.arg = Variable(settingsvar)
        self.asvar = asvar

    def render(self, context):
        ret_val = getattr(settings,str(self.arg))
        if self.asvar:
            context[self.asvar] = ret_val
            return ''
        else:
            return ret_val