import datetime
import json

from django.template.context import RequestContext
from django.shortcuts import render_to_response
from django.contrib.auth.models import User
from django.contrib.auth.decorators import login_required
from django.contrib.contenttypes.models import ContentType
from django.http import HttpResponse
from django.shortcuts import redirect
from django.core.urlresolvers import reverse

from kolibri.models import ProcessItem, ProcessResultDict
from kolibri.core import manager

dthandler = lambda obj: obj.isoformat() if isinstance(obj, datetime.datetime) else None

def active_processes(request):
    if request.is_ajax():
        try:
            import time
            time.sleep(2)
            result = []
            for item in ProcessItem.objects.filter(finished__isnull=True)[:25]:
                result.append({
                    'process_item_link': reverse('admin:kolibri_processitem_change', args=[item.id]),
                    'duration': item.started and str(datetime.datetime.today() - item.started).split('.')[0] or 'Not started',
                    'started': item.started and item.started or 'Not started',
                    'owner': str(item.owner),
                    'processor_identifier': item.processor_identifier,
                    'status':ProcessResultDict.get(item.result),
                    'content_link': item.item and item.get_admin_link() or '',
                    'item_text': item.item and str(item.item) or ''
                    })
            return HttpResponse(json.dumps(result, default=dthandler), mimetype="application/json")
        except Exception, e:
            print e
    return HttpResponse("This is a ajax view.")


def processor_status(request):
    if 1:#if request.is_ajax():
        if 1:#try:
            user = User.objects.get(username=request.GET.get('user'))
            item_type = request.GET.get('item_type')
            item_id = request.GET.get('item_id')
            app_label = request.GET.get('app_label')
            result = []
            item_count_per_processor = {}
            if item_type and app_label:
                model_type = ContentType.objects.get(app_label=app_label, model=item_type.lower())
                if item_id != "None" and item_id:
                    model_instance = model_type.get_object_for_this_type(id=int(item_id))
                    processors = manager.status.processors_for_instance(model_instance)
                    item_count_per_processor = ProcessItem.count_for_instance(model_instance)
                else:
                    processors = manager.status.processors_for_model(user, model_type.model_class())
                    item_count_per_processor = ProcessItem.count_for_model(model_type.model_class())
            else:
                processors = manager.status.processors_for_user(user)

            found = []
            for item in processors:
                if not item:
                    continue
                    
                result.append(
                        {'processor_identifier': item.identifier(),
                         'status': 'Pending',
                         'log_count': item_count_per_processor.get(item.identifier(), 0)
                    })
                found.append(item.identifier())

            for processor_identifier in [proc for proc in manager.processor.identifiers() if proc not in found]:
                result.append(
                        {'processor_identifier': processor_identifier,
                         'status': 'Free',
                         'log_count': item_count_per_processor.get(processor_identifier, 0)
                    })

            for workflow in manager.workflow.values():
                handled = False
                for processor in found:
                    if processor in [proc.identifier() for proc in workflow.processors()]:
                        result.append({'processor_identifier': workflow.identifier(), 'status': 'Pending', 'log_count': 'N/A'})
                        handled = True
                if not handled:
                    result.append({'processor_identifier': workflow.identifier(), 'status': 'Free', 'log_count': 'N/A'})

            return HttpResponse(json.dumps(result), mimetype="application/json")
        #except Exception, e:
        #    raise e
    return HttpResponse("This is a ajax view.")


def internal_execute_processor(instance_pks, model_name, request, selected_processors, selected_workflows, execution_mode=False, form_data = {}):
    """
    
    """

    if execution_mode:
        if selected_processors:
            manager.execute.processor.base(request.user, selected_processors[0], **form_data)
        return

    model_instances = []

    processors = []
    for proc in selected_processors:
        for p in manager.processor.values():
            if p.identifier() == proc and p.model.__name__ == model_name:
                if not model_instances:
                    model_instances = p.model.objects.filter(id__in=instance_pks)
                processors.append(p.identifier())

    workflows = []
    for workflow_identifier in selected_workflows:
        for workflow in manager.workflow.values():
            if workflow.identifier() == workflow_identifier and workflow.model.__name__ == model_name:
                if not model_instances:
                    model_instances = workflow.model.objects.filter(id__in=instance_pks)
                workflows.append(workflow_identifier)

    if model_instances and processors:
        manager.execute.processor.many_processors(request.user, processors, model_instances, **form_data)

    if model_instances and workflows:
        for workflow in workflows:
            manager.execute.workflow.many(request.user, workflow, model_instances, **form_data)


@login_required
def process_processor_forms(request, processors_with_forms, selected_processors, instance_pks, \
                            selected_workflows, model_name, app_label, referrer, execution_mode=False, in_admin=False):
    """

    """

    data = {
        'processors_with_forms': [manager.processor[proc] for proc in processors_with_forms],
        'forms_processed': True,
        'selected_processors': selected_processors,
        'instance_pks': instance_pks,
        'selected_workflows': selected_workflows,
        'model_name': model_name,
        'app_label': app_label,
        'referrer': referrer,
        'execution_mode': execution_mode,
        'base_html': in_admin and 'admin/base_site.html' or 'base_site.html'
    }

    return render_to_response('kolibri/forms.html', data, context_instance=RequestContext(request))


def get_processors_with_forms(selected_processors):
    result = []
    for proc in selected_processors:
        if manager.processor.has_form(proc) and proc not in result:
            result.append(proc)
    return result

def get_processor_identifiers_from_workflow(workflow_identifier):
    workflow = manager.workflow[workflow_identifier]
    return [proc.identifier() for proc in workflow.processors()]

@login_required
def execute_processor(request):
    """

    """
    referrer = request.POST.get('HTTP_REFERER', request.META.get('HTTP_REFERER'))
    selected_processors = [v for k,v in request.POST.items() if 'proc_id_' in k]
    instance_pks = [int(v) for k,v in request.POST.items() if 'pk_id_' in k]
    selected_workflows = [v for k,v in request.POST.items() if 'wf_id_' in k]
    model_name = request.POST.get('model_name')
    app_label = request.POST.get('app_label')
    execution_mode = request.POST.get('execution_mode', 'false').lower() == 'true'
    in_admin = request.POST.get('in_admin', 'false') == 'true'

    processors_with_forms = []
    if not request.POST.get('forms_processed'):
        procs = selected_processors
        for selected_workflow in selected_workflows:
            procs.extend(get_processor_identifiers_from_workflow(selected_workflow))

        processors_with_forms.extend(get_processors_with_forms(procs))

    if processors_with_forms:
        return process_processor_forms(request, processors_with_forms, selected_processors, instance_pks, \
                                       selected_workflows, model_name, app_label, referrer, execution_mode, in_admin)

    form_data = {}
    if request.POST.get('forms_processed'):
        for selected_processor in selected_processors:
            for key in request.POST.keys():
                if selected_processor in key:
                    if not selected_processor in form_data:
                        form_data[selected_processor] = {}
                    form_data[selected_processor][key.replace(u"%s-" % selected_processor, '')] = request.POST.get(key)

    internal_execute_processor(instance_pks, model_name, request, selected_processors, \
                               selected_workflows, execution_mode, form_data)

    return redirect(referrer)
