import string
from kolibri import forms

def name_from_item(item):
    """

    """
    try:
        name = hasattr(item, '__name__') and item.__name__ or \
               hasattr(item.__class__, '__name__') and item.__class__.__name__ or item.__class__
        
        module = hasattr(item, '__module__') and item.__module__ or item.__class__.__module__
        return "%s_%s" % (module.replace('.', '_'), name)
    except Exception, e:
        raise Exception("name_from_item failed for %s with exception %s. " % (item, e))


class WorkflowIsUserExlcusive(BaseException):
    """

    """
    pass


class WorkflowCannotProcessQuerysetUsingDifferentModel(BaseException):
    """

    """
    pass


class WorkflowCannotProcessQuerysetWithoutSettingAModel(BaseException):
    """

    """
    pass


class WorkflowNotFound(BaseException):
    """

    """
    pass


class DuplicateProcessorRegistration(BaseException):
    """

    """
    pass


class ProcessorNotFound(BaseException):
    """

    """
    pass


class KolibriProcessAllreadyRunning(BaseException):
    """

    """
    pass


class ProcessStatus:
    """

    """
    free = 0
    pending = 1

    @classmethod
    def choices(cls):
        """

        """
        return (
            (ProcessStatus.free, "No process running"),
            (ProcessStatus.pending, "Pending"),
        )


class Processor(object):
    """

    """
    user_exclusive = False
    only_run_once = False # v0.2.0
    has_form = False

    model = None
    _text = None

    def __init__(self, *args, **kwargs):
        """
        
        """
        self.args = args
        self.kwargs = kwargs

    @property
    def text(self):
        if self._text:
            return self._text

        result = []
        for c in self.__class__.__name__:
           if c in string.uppercase:
               if not result:
                   result.append(c)
               else:
                   result.append(' ')
                   result.append(c.lower())
           else:
               result.append(c.lower())

        return ''.join(result)

    def identifier(self):
        """

        """
        return name_from_item(self)

    def clean_up(self, user, **kwargs):
        """

        """
        pass

    def execute(self, user, **kwargs):
        """

        """
        pass
    execute.NOT_IMPLEMENTED = True

    def process(self, user, model_instance, **kwargs):
        """

        """
        pass
    process.NOT_IMPLEMENTED = True

    @property
    def implements_process(self):
        """

        """
        return hasattr(self.process, 'NOT_IMPLEMENTED') == False

    @property
    def implements_execute(self):
        """

        """
        return hasattr(self.execute, 'NOT_IMPLEMENTED') == False

    def produce_form(self):
        """
        
        """
        form, data = self.get_form()
        return form(prefix=self.identifier(), initial=data)


def singleton(cls):
    """

    """
    instances = {}

    def getinstance():
        """

        """
        if cls not in instances:
            instances[cls] = cls()
        return instances[cls]
    return getinstance


from context import Context
manager = singleton(Context)()
