# -*- coding: utf-8 -*-
"""
    lantz.drivers.ni.daqmx.constants
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    Constants and types for DAQmx

    :copyright: 2012 by Lantz Authors, see AUTHORS for more details.
    :license: BSD, see LICENSE for more details.
"""

from lantz.visalib import RichEnum

class Constants(metaclass=RichEnum):

    _PREFIX = 'DAQMX_'
    
    Buf_Input_BufSize = 0x186C
    Buf_Input_OnbrdBufSize = 0x230A
    Buf_Output_BufSize = 0x186D
    Buf_Output_OnbrdBufSize = 0x230B
    SelfCal_Supported = 0x1860
    SelfCal_LastTemp = 0x1864
    ExtCal_RecommendedInterval = 0x1868
    ExtCal_LastTemp = 0x1867
    Cal_UserDefinedInfo = 0x1861
    Cal_UserDefinedInfo_MaxSize = 0x191C
    Cal_DevTemp = 0x223B
    Cal_AccConnectionCount = 0x2FEB
    Cal_RecommendedAccConnectionCountLimit = 0x2FEC

    AI_Max = 0x17DD
    AI_Min = 0x17DE
    AI_CustomScaleName = 0x17E0
    AI_MeasType = 0x0695
    AI_Voltage_Units = 0x1094
    AI_Voltage_dBRef = 0x29B0
    AI_Voltage_ACRMS_Units = 0x17E2
    AI_Temp_Units = 0x1033
    AI_Thrmcpl_Type = 0x1050
    AI_Thrmcpl_ScaleType = 0x29D0
    AI_Thrmcpl_CJCSrc = 0x1035
    AI_Thrmcpl_CJCVal = 0x1036
    AI_Thrmcpl_CJCChan = 0x1034
    AI_RTD_Type = 0x1032
    AI_RTD_R0 = 0x1030
    AI_RTD_A = 0x1010
    AI_RTD_B = 0x1011
    AI_RTD_C = 0x1013
    AI_Thrmstr_A = 0x18C9
    AI_Thrmstr_B = 0x18CB
    AI_Thrmstr_C = 0x18CA
    AI_Thrmstr_R1 = 0x1061
    AI_ForceReadFromChan = 0x18F8
    AI_Current_Units = 0x0701
    AI_Current_ACRMS_Units = 0x17E3
    AI_Strain_Units = 0x0981
    AI_StrainGage_GageFactor = 0x0994
    AI_StrainGage_PoissonRatio = 0x0998
    AI_StrainGage_Cfg = 0x0982
    AI_Resistance_Units = 0x0955
    AI_Freq_Units = 0x0806
    AI_Freq_ThreshVoltage = 0x0815
    AI_Freq_Hyst = 0x0814
    AI_LVDT_Units = 0x0910
    AI_LVDT_Sensitivity = 0x0939
    AI_LVDT_SensitivityUnits = 0x219A
    AI_RVDT_Units = 0x0877
    AI_RVDT_Sensitivity = 0x0903
    AI_RVDT_SensitivityUnits = 0x219B
    AI_EddyCurrentProxProbe_Units = 0x2AC0
    AI_EddyCurrentProxProbe_Sensitivity = 0x2ABE
    AI_EddyCurrentProxProbe_SensitivityUnits = 0x2ABF
    AI_SoundPressure_MaxSoundPressureLvl = 0x223A
    AI_SoundPressure_Units = 0x1528
    AI_SoundPressure_dBRef = 0x29B1
    AI_Microphone_Sensitivity = 0x1536
    AI_Accel_Units = 0x0673
    AI_Accel_dBRef = 0x29B2
    AI_Accel_Sensitivity = 0x0692
    AI_Accel_SensitivityUnits = 0x219C
    AI_Force_Units = 0x2F75
    AI_Force_IEPESensor_Sensitivity = 0x2F81
    AI_Force_IEPESensor_SensitivityUnits = 0x2F82
    AI_Pressure_Units = 0x2F76
    AI_Torque_Units = 0x2F77
    AI_Bridge_Units = 0x2F92
    AI_Bridge_ElectricalUnits = 0x2F87
    AI_Bridge_PhysicalUnits = 0x2F88
    AI_Bridge_ScaleType = 0x2F89
    AI_Bridge_TwoPointLin_First_ElectricalVal = 0x2F8A
    AI_Bridge_TwoPointLin_First_PhysicalVal = 0x2F8B
    AI_Bridge_TwoPointLin_Second_ElectricalVal = 0x2F8C
    AI_Bridge_TwoPointLin_Second_PhysicalVal = 0x2F8D
    AI_Bridge_Table_ElectricalVals = 0x2F8E
    AI_Bridge_Table_PhysicalVals = 0x2F8F
    AI_Bridge_Poly_ForwardCoeff = 0x2F90
    AI_Bridge_Poly_ReverseCoeff = 0x2F91
    AI_Is_TEDS = 0x2983
    AI_TEDS_Units = 0x21E0
    AI_Coupling = 0x0064
    AI_Impedance = 0x0062
    AI_TermCfg = 0x1097
    AI_InputSrc = 0x2198
    AI_ResistanceCfg = 0x1881
    AI_LeadWireResistance = 0x17EE
    AI_Bridge_Cfg = 0x0087
    AI_Bridge_NomResistance = 0x17EC
    AI_Bridge_InitialVoltage = 0x17ED
    AI_Bridge_InitialRatio = 0x2F86
    AI_Bridge_ShuntCal_Enable = 0x0094
    AI_Bridge_ShuntCal_Select = 0x21D5
    AI_Bridge_ShuntCal_GainAdjust = 0x193F
    AI_Bridge_ShuntCal_ShuntCalAResistance = 0x2F78
    AI_Bridge_ShuntCal_ShuntCalAActualResistance = 0x2F79
    AI_Bridge_Balance_CoarsePot = 0x17F1
    AI_Bridge_Balance_FinePot = 0x18F4
    AI_CurrentShunt_Loc = 0x17F2
    AI_CurrentShunt_Resistance = 0x17F3
    AI_Excit_Src = 0x17F4
    AI_Excit_Val = 0x17F5
    AI_Excit_UseForScaling = 0x17FC
    AI_Excit_UseMultiplexed = 0x2180
    AI_Excit_ActualVal = 0x1883
    AI_Excit_DCorAC = 0x17FB
    AI_Excit_VoltageOrCurrent = 0x17F6
    AI_ACExcit_Freq = 0x0101
    AI_ACExcit_SyncEnable = 0x0102
    AI_ACExcit_WireMode = 0x18CD
    AI_OpenThrmcplDetectEnable = 0x2F72
    AI_Thrmcpl_LeadOffsetVoltage = 0x2FB8
    AI_Atten = 0x1801
    AI_ProbeAtten = 0x2A88
    AI_Lowpass_Enable = 0x1802
    AI_Lowpass_CutoffFreq = 0x1803
    AI_Lowpass_SwitchCap_ClkSrc = 0x1884
    AI_Lowpass_SwitchCap_ExtClkFreq = 0x1885
    AI_Lowpass_SwitchCap_ExtClkDiv = 0x1886
    AI_Lowpass_SwitchCap_OutClkDiv = 0x1887
    AI_FilterDelay = 0x2FED
    AI_RemoveFilterDelay = 0x2FBD
    AI_AveragingWinSize = 0x2FEE
    AI_ResolutionUnits = 0x1764
    AI_Resolution = 0x1765
    AI_RawSampSize = 0x22DA
    AI_RawSampJustification = 0x0050
    AI_ADCTimingMode = 0x29F9
    AI_ADCCustomTimingMode = 0x2F6B
    AI_Dither_Enable = 0x0068
    AI_ChanCal_HasValidCalInfo = 0x2297
    AI_ChanCal_EnableCal = 0x2298
    AI_ChanCal_ApplyCalIfExp = 0x2299
    AI_ChanCal_ScaleType = 0x229C
    AI_ChanCal_Table_PreScaledVals = 0x229D
    AI_ChanCal_Table_ScaledVals = 0x229E
    AI_ChanCal_Poly_ForwardCoeff = 0x229F
    AI_ChanCal_Poly_ReverseCoeff = 0x22A0
    AI_ChanCal_OperatorName = 0x22A3
    AI_ChanCal_Desc = 0x22A4
    AI_ChanCal_Verif_RefVals = 0x22A1
    AI_ChanCal_Verif_AcqVals = 0x22A2
    AI_Rng_High = 0x1815
    AI_Rng_Low = 0x1816
    AI_DCOffset = 0x2A89
    AI_Gain = 0x1818
    AI_SampAndHold_Enable = 0x181A
    AI_AutoZeroMode = 0x1760
    AI_DataXferMech = 0x1821
    AI_DataXferReqCond = 0x188B
    AI_DataXferCustomThreshold = 0x230C
    AI_UsbXferReqSize = 0x2A8E
    AI_MemMapEnable = 0x188C
    AI_RawDataCompressionType = 0x22D8
    AI_LossyLSBRemoval_CompressedSampSize = 0x22D9
    AI_DevScalingCoeff = 0x1930
    AI_EnhancedAliasRejectionEnable = 0x2294
    AO_Max = 0x1186
    AO_Min = 0x1187
    AO_CustomScaleName = 0x1188
    AO_OutputType = 0x1108
    AO_Voltage_Units = 0x1184
    AO_Voltage_CurrentLimit = 0x2A1D
    AO_Current_Units = 0x1109
    AO_FuncGen_Type = 0x2A18
    AO_FuncGen_Freq = 0x2A19
    AO_FuncGen_Amplitude = 0x2A1A
    AO_FuncGen_Offset = 0x2A1B
    AO_FuncGen_Square_DutyCycle = 0x2A1C
    AO_FuncGen_ModulationType = 0x2A22
    AO_FuncGen_FMDeviation = 0x2A23
    AO_OutputImpedance = 0x1490
    AO_LoadImpedance = 0x0121
    AO_IdleOutputBehavior = 0x2240
    AO_TermCfg = 0x188E
    AO_ResolutionUnits = 0x182B
    AO_Resolution = 0x182C
    AO_DAC_Rng_High = 0x182E
    AO_DAC_Rng_Low = 0x182D
    AO_DAC_Ref_ConnToGnd = 0x0130
    AO_DAC_Ref_AllowConnToGnd = 0x1830
    AO_DAC_Ref_Src = 0x0132
    AO_DAC_Ref_ExtSrc = 0x2252
    AO_DAC_Ref_Val = 0x1832
    AO_DAC_Offset_Src = 0x2253
    AO_DAC_Offset_ExtSrc = 0x2254
    AO_DAC_Offset_Val = 0x2255
    AO_ReglitchEnable = 0x0133
    AO_Gain = 0x0118
    AO_UseOnlyOnBrdMem = 0x183A
    AO_DataXferMech = 0x0134
    AO_DataXferReqCond = 0x183C
    AO_UsbXferReqSize = 0x2A8F
    AO_MemMapEnable = 0x188F
    AO_DevScalingCoeff = 0x1931
    AO_EnhancedImageRejectionEnable = 0x2241

    DI_InvertLines = 0x0793
    DI_NumLines = 0x2178
    DI_DigFltr_Enable = 0x21D6
    DI_DigFltr_MinPulseWidth = 0x21D7
    DI_DigFltr_EnableBusMode = 0x2EFE
    DI_DigFltr_TimebaseSrc = 0x2ED4
    DI_DigFltr_TimebaseRate = 0x2ED5
    DI_DigSync_Enable = 0x2ED6
    DI_Tristate = 0x1890
    DI_LogicFamily = 0x296D
    DI_DataXferMech = 0x2263
    DI_DataXferReqCond = 0x2264
    DI_UsbXferReqSize = 0x2A90
    DI_MemMapEnable = 0x296A
    DI_AcquireOn = 0x2966
    DO_OutputDriveType = 0x1137
    DO_InvertLines = 0x1133
    DO_NumLines = 0x2179
    DO_Tristate = 0x18F3
    DO_LineStates_StartState = 0x2972
    DO_LineStates_PausedState = 0x2967
    DO_LineStates_DoneState = 0x2968
    DO_LogicFamily = 0x296E
    DO_Overcurrent_Limit = 0x2A85
    DO_Overcurrent_AutoReenable = 0x2A86
    DO_Overcurrent_ReenablePeriod = 0x2A87
    DO_UseOnlyOnBrdMem = 0x2265
    DO_DataXferMech = 0x2266
    DO_DataXferReqCond = 0x2267
    DO_UsbXferReqSize = 0x2A91
    DO_MemMapEnable = 0x296B
    DO_GenerateOn = 0x2969

    CI_Max = 0x189C
    CI_Min = 0x189D
    CI_CustomScaleName = 0x189E
    CI_MeasType = 0x18A0
    CI_Freq_Units = 0x18A1
    CI_Freq_Term = 0x18A2
    CI_Freq_StartingEdge = 0x0799
    CI_Freq_MeasMeth = 0x0144
    CI_Freq_EnableAveraging = 0x2ED0
    CI_Freq_MeasTime = 0x0145
    CI_Freq_Div = 0x0147
    CI_Freq_DigFltr_Enable = 0x21E7
    CI_Freq_DigFltr_MinPulseWidth = 0x21E8
    CI_Freq_DigFltr_TimebaseSrc = 0x21E9
    CI_Freq_DigFltr_TimebaseRate = 0x21EA
    CI_Freq_DigSync_Enable = 0x21EB
    CI_Period_Units = 0x18A3
    CI_Period_Term = 0x18A4
    CI_Period_StartingEdge = 0x0852
    CI_Period_MeasMeth = 0x192C
    CI_Period_EnableAveraging = 0x2ED1
    CI_Period_MeasTime = 0x192D
    CI_Period_Div = 0x192E
    CI_Period_DigFltr_Enable = 0x21EC
    CI_Period_DigFltr_MinPulseWidth = 0x21ED
    CI_Period_DigFltr_TimebaseSrc = 0x21EE
    CI_Period_DigFltr_TimebaseRate = 0x21EF
    CI_Period_DigSync_Enable = 0x21F0
    CI_CountEdges_Term = 0x18C7
    CI_CountEdges_Dir = 0x0696
    CI_CountEdges_DirTerm = 0x21E1
    CI_CountEdges_CountDir_DigFltr_Enable = 0x21F1
    CI_CountEdges_CountDir_DigFltr_MinPulseWidth = 0x21F2
    CI_CountEdges_CountDir_DigFltr_TimebaseSrc = 0x21F3
    CI_CountEdges_CountDir_DigFltr_TimebaseRate = 0x21F4
    CI_CountEdges_CountDir_DigSync_Enable = 0x21F5
    CI_CountEdges_InitialCnt = 0x0698
    CI_CountEdges_ActiveEdge = 0x0697
    CI_CountEdges_CountReset_Enable = 0x2FAF
    CI_CountEdges_CountReset_ResetCount = 0x2FB0
    CI_CountEdges_CountReset_Term = 0x2FB1
    CI_CountEdges_CountReset_ActiveEdge = 0x2FB2
    CI_CountEdges_CountReset_DigFltr_Enable = 0x2FB3
    CI_CountEdges_CountReset_DigFltr_MinPulseWidth = 0x2FB4
    CI_CountEdges_CountReset_DigFltr_TimebaseSrc = 0x2FB5
    CI_CountEdges_CountReset_DigFltr_TimebaseRate = 0x2FB6
    CI_CountEdges_CountReset_DigSync_Enable = 0x2FB7
    CI_CountEdges_DigFltr_Enable = 0x21F6
    CI_CountEdges_DigFltr_MinPulseWidth = 0x21F7
    CI_CountEdges_DigFltr_TimebaseSrc = 0x21F8
    CI_CountEdges_DigFltr_TimebaseRate = 0x21F9
    CI_CountEdges_DigSync_Enable = 0x21FA
    CI_AngEncoder_Units = 0x18A6
    CI_AngEncoder_PulsesPerRev = 0x0875
    CI_AngEncoder_InitialAngle = 0x0881
    CI_LinEncoder_Units = 0x18A9
    CI_LinEncoder_DistPerPulse = 0x0911
    CI_LinEncoder_InitialPos = 0x0915
    CI_Encoder_DecodingType = 0x21E6
    CI_Encoder_AInputTerm = 0x219D
    CI_Encoder_AInput_DigFltr_Enable = 0x21FB
    CI_Encoder_AInput_DigFltr_MinPulseWidth = 0x21FC
    CI_Encoder_AInput_DigFltr_TimebaseSrc = 0x21FD
    CI_Encoder_AInput_DigFltr_TimebaseRate = 0x21FE
    CI_Encoder_AInput_DigSync_Enable = 0x21FF
    CI_Encoder_BInputTerm = 0x219E
    CI_Encoder_BInput_DigFltr_Enable = 0x2200
    CI_Encoder_BInput_DigFltr_MinPulseWidth = 0x2201
    CI_Encoder_BInput_DigFltr_TimebaseSrc = 0x2202
    CI_Encoder_BInput_DigFltr_TimebaseRate = 0x2203
    CI_Encoder_BInput_DigSync_Enable = 0x2204
    CI_Encoder_ZInputTerm = 0x219F
    CI_Encoder_ZInput_DigFltr_Enable = 0x2205
    CI_Encoder_ZInput_DigFltr_MinPulseWidth = 0x2206
    CI_Encoder_ZInput_DigFltr_TimebaseSrc = 0x2207
    CI_Encoder_ZInput_DigFltr_TimebaseRate = 0x2208
    CI_Encoder_ZInput_DigSync_Enable = 0x2209
    CI_Encoder_ZIndexEnable = 0x0890
    CI_Encoder_ZIndexVal = 0x0888
    CI_Encoder_ZIndexPhase = 0x0889
    CI_PulseWidth_Units = 0x0823
    CI_PulseWidth_Term = 0x18AA
    CI_PulseWidth_StartingEdge = 0x0825
    CI_PulseWidth_DigFltr_Enable = 0x220A
    CI_PulseWidth_DigFltr_MinPulseWidth = 0x220B
    CI_PulseWidth_DigFltr_TimebaseSrc = 0x220C
    CI_PulseWidth_DigFltr_TimebaseRate = 0x220D
    CI_PulseWidth_DigSync_Enable = 0x220E
    CI_TwoEdgeSep_Units = 0x18AC
    CI_TwoEdgeSep_FirstTerm = 0x18AD
    CI_TwoEdgeSep_FirstEdge = 0x0833
    CI_TwoEdgeSep_First_DigFltr_Enable = 0x220F
    CI_TwoEdgeSep_First_DigFltr_MinPulseWidth = 0x2210
    CI_TwoEdgeSep_First_DigFltr_TimebaseSrc = 0x2211
    CI_TwoEdgeSep_First_DigFltr_TimebaseRate = 0x2212
    CI_TwoEdgeSep_First_DigSync_Enable = 0x2213
    CI_TwoEdgeSep_SecondTerm = 0x18AE
    CI_TwoEdgeSep_SecondEdge = 0x0834
    CI_TwoEdgeSep_Second_DigFltr_Enable = 0x2214
    CI_TwoEdgeSep_Second_DigFltr_MinPulseWidth = 0x2215
    CI_TwoEdgeSep_Second_DigFltr_TimebaseSrc = 0x2216
    CI_TwoEdgeSep_Second_DigFltr_TimebaseRate = 0x2217
    CI_TwoEdgeSep_Second_DigSync_Enable = 0x2218
    CI_SemiPeriod_Units = 0x18AF
    CI_SemiPeriod_Term = 0x18B0
    CI_SemiPeriod_StartingEdge = 0x22FE
    CI_SemiPeriod_DigFltr_Enable = 0x2219
    CI_SemiPeriod_DigFltr_MinPulseWidth = 0x221A
    CI_SemiPeriod_DigFltr_TimebaseSrc = 0x221B
    CI_SemiPeriod_DigFltr_TimebaseRate = 0x221C
    CI_SemiPeriod_DigSync_Enable = 0x221D
    CI_Pulse_Freq_Units = 0x2F0B
    CI_Pulse_Freq_Term = 0x2F04
    CI_Pulse_Freq_Start_Edge = 0x2F05
    CI_Pulse_Freq_DigFltr_Enable = 0x2F06
    CI_Pulse_Freq_DigFltr_MinPulseWidth = 0x2F07
    CI_Pulse_Freq_DigFltr_TimebaseSrc = 0x2F08
    CI_Pulse_Freq_DigFltr_TimebaseRate = 0x2F09
    CI_Pulse_Freq_DigSync_Enable = 0x2F0A
    CI_Pulse_Time_Units = 0x2F13
    CI_Pulse_Time_Term = 0x2F0C
    CI_Pulse_Time_StartEdge = 0x2F0D
    CI_Pulse_Time_DigFltr_Enable = 0x2F0E
    CI_Pulse_Time_DigFltr_MinPulseWidth = 0x2F0F
    CI_Pulse_Time_DigFltr_TimebaseSrc = 0x2F10
    CI_Pulse_Time_DigFltr_TimebaseRate = 0x2F11
    CI_Pulse_Time_DigSync_Enable = 0x2F12
    CI_Pulse_Ticks_Term = 0x2F14
    CI_Pulse_Ticks_StartEdge = 0x2F15
    CI_Pulse_Ticks_DigFltr_Enable = 0x2F16
    CI_Pulse_Ticks_DigFltr_MinPulseWidth = 0x2F17
    CI_Pulse_Ticks_DigFltr_TimebaseSrc = 0x2F18
    CI_Pulse_Ticks_DigFltr_TimebaseRate = 0x2F19
    CI_Pulse_Ticks_DigSync_Enable = 0x2F1A
    CI_Timestamp_Units = 0x22B3
    CI_Timestamp_InitialSeconds = 0x22B4
    CI_GPS_SyncMethod = 0x1092
    CI_GPS_SyncSrc = 0x1093
    CI_CtrTimebaseSrc = 0x0143
    CI_CtrTimebaseRate = 0x18B2
    CI_CtrTimebaseActiveEdge = 0x0142
    CI_CtrTimebase_DigFltr_Enable = 0x2271
    CI_CtrTimebase_DigFltr_MinPulseWidth = 0x2272
    CI_CtrTimebase_DigFltr_TimebaseSrc = 0x2273
    CI_CtrTimebase_DigFltr_TimebaseRate = 0x2274
    CI_CtrTimebase_DigSync_Enable = 0x2275
    CI_Count = 0x0148
    CI_OutputState = 0x0149
    CI_TCReached = 0x0150
    CI_CtrTimebaseMasterTimebaseDiv = 0x18B3
    CI_DataXferMech = 0x0200
    CI_DataXferReqCond = 0x2EFB
    CI_UsbXferReqSize = 0x2A92
    CI_MemMapEnable = 0x2ED2
    CI_NumPossiblyInvalidSamps = 0x193C
    CI_DupCountPrevent = 0x21AC
    CI_Prescaler = 0x2239

    CO_OutputType = 0x18B5
    CO_Pulse_IdleState = 0x1170
    CO_Pulse_Term = 0x18E1
    CO_Pulse_Time_Units = 0x18D6
    CO_Pulse_HighTime = 0x18BA
    CO_Pulse_LowTime = 0x18BB
    CO_Pulse_Time_InitialDelay = 0x18BC
    CO_Pulse_DutyCyc = 0x1176
    CO_Pulse_Freq_Units = 0x18D5
    CO_Pulse_Freq = 0x1178
    CO_Pulse_Freq_InitialDelay = 0x0299
    CO_Pulse_HighTicks = 0x1169
    CO_Pulse_LowTicks = 0x1171
    CO_Pulse_Ticks_InitialDelay = 0x0298
    CO_CtrTimebaseSrc = 0x0339
    CO_CtrTimebaseRate = 0x18C2
    CO_CtrTimebaseActiveEdge = 0x0341
    CO_CtrTimebase_DigFltr_Enable = 0x2276
    CO_CtrTimebase_DigFltr_MinPulseWidth = 0x2277
    CO_CtrTimebase_DigFltr_TimebaseSrc = 0x2278
    CO_CtrTimebase_DigFltr_TimebaseRate = 0x2279
    CO_CtrTimebase_DigSync_Enable = 0x227A
    CO_Count = 0x0293
    CO_OutputState = 0x0294
    CO_AutoIncrCnt = 0x0295
    CO_CtrTimebaseMasterTimebaseDiv = 0x18C3
    CO_PulseDone = 0x190E
    CO_EnableInitialDelayOnRetrigger = 0x2EC9
    CO_ConstrainedGenMode = 0x29F2
    CO_UseOnlyOnBrdMem = 0x2ECB
    CO_DataXferMech = 0x2ECC
    CO_DataXferReqCond = 0x2ECD
    CO_UsbXferReqSize = 0x2A93
    CO_MemMapEnable = 0x2ED3
    CO_Prescaler = 0x226D
    CO_RdyForNewVal = 0x22FF

    ChanType = 0x187F
    PhysicalChanName = 0x18F5
    ChanDescr = 0x1926
    ChanIsGlobal = 0x2304
    Exported_AIConvClk_OutputTerm = 0x1687
    Exported_AIConvClk_Pulse_Polarity = 0x1688
    Exported_10MHzRefClk_OutputTerm = 0x226E
    Exported_20MHzTimebase_OutputTerm = 0x1657
    Exported_SampClk_OutputBehavior = 0x186B
    Exported_SampClk_OutputTerm = 0x1663
    Exported_SampClk_DelayOffset = 0x21C4
    Exported_SampClk_Pulse_Polarity = 0x1664
    Exported_SampClkTimebase_OutputTerm = 0x18F9
    Exported_DividedSampClkTimebase_OutputTerm = 0x21A1
    Exported_AdvTrig_OutputTerm = 0x1645
    Exported_AdvTrig_Pulse_Polarity = 0x1646
    Exported_AdvTrig_Pulse_WidthUnits = 0x1647
    Exported_AdvTrig_Pulse_Width = 0x1648
    Exported_PauseTrig_OutputTerm = 0x1615
    Exported_PauseTrig_Lvl_ActiveLvl = 0x1616
    Exported_RefTrig_OutputTerm = 0x0590
    Exported_RefTrig_Pulse_Polarity = 0x0591
    Exported_StartTrig_OutputTerm = 0x0584
    Exported_StartTrig_Pulse_Polarity = 0x0585
    Exported_AdvCmpltEvent_OutputTerm = 0x1651
    Exported_AdvCmpltEvent_Delay = 0x1757
    Exported_AdvCmpltEvent_Pulse_Polarity = 0x1652
    Exported_AdvCmpltEvent_Pulse_Width = 0x1654
    Exported_AIHoldCmpltEvent_OutputTerm = 0x18ED
    Exported_AIHoldCmpltEvent_PulsePolarity = 0x18EE
    Exported_ChangeDetectEvent_OutputTerm = 0x2197
    Exported_ChangeDetectEvent_Pulse_Polarity = 0x2303
    Exported_CtrOutEvent_OutputTerm = 0x1717
    Exported_CtrOutEvent_OutputBehavior = 0x174F
    Exported_CtrOutEvent_Pulse_Polarity = 0x1718
    Exported_CtrOutEvent_Toggle_IdleState = 0x186A
    Exported_HshkEvent_OutputTerm = 0x22BA
    Exported_HshkEvent_OutputBehavior = 0x22BB
    Exported_HshkEvent_Delay = 0x22BC
    Exported_HshkEvent_Interlocked_AssertedLvl = 0x22BD
    Exported_HshkEvent_Interlocked_AssertOnStart = 0x22BE
    Exported_HshkEvent_Interlocked_DeassertDelay = 0x22BF
    Exported_HshkEvent_Pulse_Polarity = 0x22C0
    Exported_HshkEvent_Pulse_Width = 0x22C1
    Exported_RdyForXferEvent_OutputTerm = 0x22B5
    Exported_RdyForXferEvent_Lvl_ActiveLvl = 0x22B6
    Exported_RdyForXferEvent_DeassertCond = 0x2963
    Exported_RdyForXferEvent_DeassertCondCustomThreshold = 0x2964
    Exported_DataActiveEvent_OutputTerm = 0x1633
    Exported_DataActiveEvent_Lvl_ActiveLvl = 0x1634
    Exported_RdyForStartEvent_OutputTerm = 0x1609
    Exported_RdyForStartEvent_Lvl_ActiveLvl = 0x1751
    Exported_SyncPulseEvent_OutputTerm = 0x223C
    Exported_WatchdogExpiredEvent_OutputTerm = 0x21AA

    Dev_IsSimulated = 0x22CA
    Dev_ProductCategory = 0x29A9
    Dev_ProductType = 0x0631
    Dev_ProductNum = 0x231D
    Dev_SerialNum = 0x0632
    Dev_Accessory_ProductTypes = 0x2F6D
    Dev_Accessory_ProductNums = 0x2F6E
    Dev_Accessory_SerialNums = 0x2F6F
    Carrier_SerialNum = 0x2A8A
    Dev_Chassis_ModuleDevNames = 0x29B6
    Dev_AnlgTrigSupported = 0x2984
    Dev_DigTrigSupported = 0x2985
    Dev_AI_PhysicalChans = 0x231E
    Dev_AI_SupportedMeasTypes = 0x2FD2
    Dev_AI_MaxSingleChanRate = 0x298C
    Dev_AI_MaxMultiChanRate = 0x298D
    Dev_AI_MinRate = 0x298E
    Dev_AI_SimultaneousSamplingSupported = 0x298F
    Dev_AI_SampModes = 0x2FDC
    Dev_AI_TrigUsage = 0x2986
    Dev_AI_VoltageRngs = 0x2990
    Dev_AI_VoltageIntExcitDiscreteVals = 0x29C9
    Dev_AI_VoltageIntExcitRangeVals = 0x29CA
    Dev_AI_CurrentRngs = 0x2991
    Dev_AI_CurrentIntExcitDiscreteVals = 0x29CB
    Dev_AI_BridgeRngs = 0x2FD0
    Dev_AI_ResistanceRngs = 0x2A15
    Dev_AI_FreqRngs = 0x2992
    Dev_AI_Gains = 0x2993
    Dev_AI_Couplings = 0x2994
    Dev_AI_LowpassCutoffFreqDiscreteVals = 0x2995
    Dev_AI_LowpassCutoffFreqRangeVals = 0x29CF
    Dev_AO_PhysicalChans = 0x231F
    Dev_AO_SupportedOutputTypes = 0x2FD3
    Dev_AO_SampClkSupported = 0x2996
    Dev_AO_SampModes = 0x2FDD
    Dev_AO_MaxRate = 0x2997
    Dev_AO_MinRate = 0x2998
    Dev_AO_TrigUsage = 0x2987
    Dev_AO_VoltageRngs = 0x299B
    Dev_AO_CurrentRngs = 0x299C
    Dev_AO_Gains = 0x299D
    Dev_DI_Lines = 0x2320
    Dev_DI_Ports = 0x2321
    Dev_DI_MaxRate = 0x2999
    Dev_DI_TrigUsage = 0x2988
    Dev_DO_Lines = 0x2322
    Dev_DO_Ports = 0x2323
    Dev_DO_MaxRate = 0x299A
    Dev_DO_TrigUsage = 0x2989
    Dev_CI_PhysicalChans = 0x2324
    Dev_CI_SupportedMeasTypes = 0x2FD4
    Dev_CI_TrigUsage = 0x298A
    Dev_CI_SampClkSupported = 0x299E
    Dev_CI_SampModes = 0x2FDE
    Dev_CI_MaxSize = 0x299F
    Dev_CI_MaxTimebase = 0x29A0
    Dev_CO_PhysicalChans = 0x2325
    Dev_CO_SupportedOutputTypes = 0x2FD5
    Dev_CO_SampClkSupported = 0x2F5B
    Dev_CO_SampModes = 0x2FDF
    Dev_CO_TrigUsage = 0x298B
    Dev_CO_MaxSize = 0x29A1
    Dev_CO_MaxTimebase = 0x29A2
    Dev_TEDS_HWTEDSSupported = 0x2FD6
    Dev_NumDMAChans = 0x233C
    Dev_BusType = 0x2326
    Dev_PCI_BusNum = 0x2327
    Dev_PCI_DevNum = 0x2328
    Dev_PXI_ChassisNum = 0x2329
    Dev_PXI_SlotNum = 0x232A
    Dev_CompactDAQ_ChassisDevName = 0x29B7
    Dev_CompactDAQ_SlotNum = 0x29B8
    Dev_TCPIP_Hostname = 0x2A8B
    Dev_TCPIP_EthernetIP = 0x2A8C
    Dev_TCPIP_WirelessIP = 0x2A8D
    Dev_Terminals = 0x2A40

    Read_RelativeTo = 0x190A
    Read_Offset = 0x190B
    Read_ChannelsToRead = 0x1823
    Read_ReadAllAvailSamp = 0x1215
    Read_AutoStart = 0x1826
    Read_OverWrite = 0x1211
    Read_CurrReadPos = 0x1221
    Read_AvailSampPerChan = 0x1223
    Logging_FilePath = 0x2EC4
    Logging_Mode = 0x2EC5
    Logging_TDMS_GroupName = 0x2EC6
    Logging_TDMS_Operation = 0x2EC7
    Logging_Pause = 0x2FE3
    Logging_SampsPerFile = 0x2FE4
    Logging_FileWriteSize = 0x2FC3
    Logging_FilePreallocationSize = 0x2FC6
    Read_TotalSampPerChanAcquired = 0x192A
    Read_CommonModeRangeErrorChansExist = 0x2A98
    Read_CommonModeRangeErrorChans = 0x2A99
    Read_OvercurrentChansExist = 0x29E6
    Read_OvercurrentChans = 0x29E7
    Read_OpenCurrentLoopChansExist = 0x2A09
    Read_OpenCurrentLoopChans = 0x2A0A
    Read_OpenThrmcplChansExist = 0x2A96
    Read_OpenThrmcplChans = 0x2A97
    Read_OverloadedChansExist = 0x2174
    Read_OverloadedChans = 0x2175
    Read_AccessoryInsertionOrRemovalDetected = 0x2F70
    Read_DevsWithInsertedOrRemovedAccessories = 0x2F71
    Read_ChangeDetect_HasOverflowed = 0x2194
    Read_RawDataWidth = 0x217A
    Read_NumChans = 0x217B
    Read_DigitalLines_BytesPerChan = 0x217C
    Read_WaitMode = 0x2232
    Read_SleepTime = 0x22B0
    RealTime_ConvLateErrorsToWarnings = 0x22EE
    RealTime_NumOfWarmupIters = 0x22ED
    RealTime_WaitForNextSampClkWaitMode = 0x22EF
    RealTime_ReportMissedSamp = 0x2319
    RealTime_WriteRecoveryMode = 0x231A
    SwitchChan_Usage = 0x18E4
    SwitchChan_AnlgBusSharingEnable = 0x2F9E
    SwitchChan_MaxACCarryCurrent = 0x0648
    SwitchChan_MaxACSwitchCurrent = 0x0646
    SwitchChan_MaxACCarryPwr = 0x0642
    SwitchChan_MaxACSwitchPwr = 0x0644
    SwitchChan_MaxDCCarryCurrent = 0x0647
    SwitchChan_MaxDCSwitchCurrent = 0x0645
    SwitchChan_MaxDCCarryPwr = 0x0643
    SwitchChan_MaxDCSwitchPwr = 0x0649
    SwitchChan_MaxACVoltage = 0x0651
    SwitchChan_MaxDCVoltage = 0x0650
    SwitchChan_WireMode = 0x18E5
    SwitchChan_Bandwidth = 0x0640
    SwitchChan_Impedance = 0x0641
    SwitchDev_SettlingTime = 0x1244
    SwitchDev_AutoConnAnlgBus = 0x17DA
    SwitchDev_PwrDownLatchRelaysAfterSettling = 0x22DB
    SwitchDev_Settled = 0x1243
    SwitchDev_RelayList = 0x17DC
    SwitchDev_NumRelays = 0x18E6
    SwitchDev_SwitchChanList = 0x18E7
    SwitchDev_NumSwitchChans = 0x18E8
    SwitchDev_NumRows = 0x18E9
    SwitchDev_NumColumns = 0x18EA
    SwitchDev_Topology = 0x193D
    SwitchScan_BreakMode = 0x1247
    SwitchScan_RepeatMode = 0x1248
    SwitchScan_WaitingForAdv = 0x17D9
    Scale_Descr = 0x1226
    Scale_ScaledUnits = 0x191B
    Scale_PreScaledUnits = 0x18F7
    Scale_Type = 0x1929
    Scale_Lin_Slope = 0x1227
    Scale_Lin_YIntercept = 0x1228
    Scale_Map_ScaledMax = 0x1229
    Scale_Map_PreScaledMax = 0x1231
    Scale_Map_ScaledMin = 0x1230
    Scale_Map_PreScaledMin = 0x1232
    Scale_Poly_ForwardCoeff = 0x1234
    Scale_Poly_ReverseCoeff = 0x1235
    Scale_Table_ScaledVals = 0x1236
    Scale_Table_PreScaledVals = 0x1237
    Sys_GlobalChans = 0x1265
    Sys_Scales = 0x1266
    Sys_Tasks = 0x1267
    Sys_DevNames = 0x193B
    Sys_NIDAQMajorVersion = 0x1272
    Sys_NIDAQMinorVersion = 0x1923
    Sys_NIDAQUpdateVersion = 0x2F22
    Task_Name = 0x1276
    Task_Channels = 0x1273
    Task_NumChans = 0x2181
    Task_Devices = 0x230E
    Task_NumDevices = 0x29BA
    Task_Complete = 0x1274
    SampQuant_SampMode = 0x1300
    SampQuant_SampPerChan = 0x1310
    SampTimingType = 0x1347
    SampClk_Rate = 0x1344
    SampClk_MaxRate = 0x22C8
    SampClk_Src = 0x1852
    SampClk_ActiveEdge = 0x1301
    SampClk_OverrunBehavior = 0x2EFC
    SampClk_UnderflowBehavior = 0x2961
    SampClk_TimebaseDiv = 0x18EB
    SampClk_Term = 0x2F1B
    SampClk_Timebase_Rate = 0x1303
    SampClk_Timebase_Src = 0x1308
    SampClk_Timebase_ActiveEdge = 0x18EC
    SampClk_Timebase_MasterTimebaseDiv = 0x1305
    SampClkTimebase_Term = 0x2F1C
    SampClk_DigFltr_Enable = 0x221E
    SampClk_DigFltr_MinPulseWidth = 0x221F
    SampClk_DigFltr_TimebaseSrc = 0x2220
    SampClk_DigFltr_TimebaseRate = 0x2221
    SampClk_DigSync_Enable = 0x2222
    Hshk_DelayAfterXfer = 0x22C2
    Hshk_StartCond = 0x22C3
    Hshk_SampleInputDataWhen = 0x22C4
    ChangeDetect_DI_RisingEdgePhysicalChans = 0x2195
    ChangeDetect_DI_FallingEdgePhysicalChans = 0x2196
    ChangeDetect_DI_Tristate = 0x2EFA
    OnDemand_SimultaneousAOEnable = 0x21A0
    Implicit_UnderflowBehavior = 0x2EFD
    AIConv_Rate = 0x1848
    AIConv_MaxRate = 0x22C9
    AIConv_Src = 0x1502
    AIConv_ActiveEdge = 0x1853
    AIConv_TimebaseDiv = 0x1335
    AIConv_Timebase_Src = 0x1339
    DelayFromSampClk_DelayUnits = 0x1304
    DelayFromSampClk_Delay = 0x1317
    AIConv_DigFltr_Enable = 0x2EDC
    AIConv_DigFltr_MinPulseWidth = 0x2EDD
    AIConv_DigFltr_TimebaseSrc = 0x2EDE
    AIConv_DigFltr_TimebaseRate = 0x2EDF
    AIConv_DigSync_Enable = 0x2EE0
    MasterTimebase_Rate = 0x1495
    MasterTimebase_Src = 0x1343
    RefClk_Rate = 0x1315
    RefClk_Src = 0x1316
    SyncPulse_Src = 0x223D
    SyncPulse_SyncTime = 0x223E
    SyncPulse_MinDelayToStart = 0x223F
    SyncPulse_ResetTime = 0x2F7C
    SyncPulse_ResetDelay = 0x2F7D
    SyncPulse_Term = 0x2F85
    SyncClk_Interval = 0x2F7E
    SampTimingEngine = 0x2A26
    StartTrig_Type = 0x1393
    StartTrig_Term = 0x2F1E
    DigEdge_StartTrig_Src = 0x1407
    DigEdge_StartTrig_Edge = 0x1404
    DigEdge_StartTrig_DigFltr_Enable = 0x2223
    DigEdge_StartTrig_DigFltr_MinPulseWidth = 0x2224
    DigEdge_StartTrig_DigFltr_TimebaseSrc = 0x2225
    DigEdge_StartTrig_DigFltr_TimebaseRate = 0x2226
    DigEdge_StartTrig_DigSync_Enable = 0x2227
    DigPattern_StartTrig_Src = 0x1410
    DigPattern_StartTrig_Pattern = 0x2186
    DigPattern_StartTrig_When = 0x1411
    AnlgEdge_StartTrig_Src = 0x1398
    AnlgEdge_StartTrig_Slope = 0x1397
    AnlgEdge_StartTrig_Lvl = 0x1396
    AnlgEdge_StartTrig_Hyst = 0x1395
    AnlgEdge_StartTrig_Coupling = 0x2233
    AnlgEdge_StartTrig_DigFltr_Enable = 0x2EE1
    AnlgEdge_StartTrig_DigFltr_MinPulseWidth = 0x2EE2
    AnlgEdge_StartTrig_DigFltr_TimebaseSrc = 0x2EE3
    AnlgEdge_StartTrig_DigFltr_TimebaseRate = 0x2EE4
    AnlgEdge_StartTrig_DigSync_Enable = 0x2EE5
    AnlgWin_StartTrig_Src = 0x1400
    AnlgWin_StartTrig_When = 0x1401
    AnlgWin_StartTrig_Top = 0x1403
    AnlgWin_StartTrig_Btm = 0x1402
    AnlgWin_StartTrig_Coupling = 0x2234
    AnlgWin_StartTrig_DigFltr_Enable = 0x2EFF
    AnlgWin_StartTrig_DigFltr_MinPulseWidth = 0x2F00
    AnlgWin_StartTrig_DigFltr_TimebaseSrc = 0x2F01
    AnlgWin_StartTrig_DigFltr_TimebaseRate = 0x2F02
    AnlgWin_StartTrig_DigSync_Enable = 0x2F03
    StartTrig_Delay = 0x1856
    StartTrig_DelayUnits = 0x18C8
    StartTrig_Retriggerable = 0x190F
    RefTrig_Type = 0x1419
    RefTrig_PretrigSamples = 0x1445
    RefTrig_Term = 0x2F1F
    DigEdge_RefTrig_Src = 0x1434
    DigEdge_RefTrig_Edge = 0x1430
    DigEdge_RefTrig_DigFltr_Enable = 0x2ED7
    DigEdge_RefTrig_DigFltr_MinPulseWidth = 0x2ED8
    DigEdge_RefTrig_DigFltr_TimebaseSrc = 0x2ED9
    DigEdge_RefTrig_DigFltr_TimebaseRate = 0x2EDA
    DigEdge_RefTrig_DigSync_Enable = 0x2EDB
    DigPattern_RefTrig_Src = 0x1437
    DigPattern_RefTrig_Pattern = 0x2187
    DigPattern_RefTrig_When = 0x1438
    AnlgEdge_RefTrig_Src = 0x1424
    AnlgEdge_RefTrig_Slope = 0x1423
    AnlgEdge_RefTrig_Lvl = 0x1422
    AnlgEdge_RefTrig_Hyst = 0x1421
    AnlgEdge_RefTrig_Coupling = 0x2235
    AnlgEdge_RefTrig_DigFltr_Enable = 0x2EE6
    AnlgEdge_RefTrig_DigFltr_MinPulseWidth = 0x2EE7
    AnlgEdge_RefTrig_DigFltr_TimebaseSrc = 0x2EE8
    AnlgEdge_RefTrig_DigFltr_TimebaseRate = 0x2EE9
    AnlgEdge_RefTrig_DigSync_Enable = 0x2EEA
    AnlgWin_RefTrig_Src = 0x1426
    AnlgWin_RefTrig_When = 0x1427
    AnlgWin_RefTrig_Top = 0x1429
    AnlgWin_RefTrig_Btm = 0x1428
    AnlgWin_RefTrig_Coupling = 0x1857
    AnlgWin_RefTrig_DigFltr_Enable = 0x2EEB
    AnlgWin_RefTrig_DigFltr_MinPulseWidth = 0x2EEC
    AnlgWin_RefTrig_DigFltr_TimebaseSrc = 0x2EED
    AnlgWin_RefTrig_DigFltr_TimebaseRate = 0x2EEE
    AnlgWin_RefTrig_DigSync_Enable = 0x2EEF
    RefTrig_AutoTrigEnable = 0x2EC1
    RefTrig_AutoTriggered = 0x2EC2
    RefTrig_Delay = 0x1483
    AdvTrig_Type = 0x1365
    DigEdge_AdvTrig_Src = 0x1362
    DigEdge_AdvTrig_Edge = 0x1360
    DigEdge_AdvTrig_DigFltr_Enable = 0x2238
    HshkTrig_Type = 0x22B7
    Interlocked_HshkTrig_Src = 0x22B8
    Interlocked_HshkTrig_AssertedLvl = 0x22B9
    PauseTrig_Type = 0x1366
    PauseTrig_Term = 0x2F20
    AnlgLvl_PauseTrig_Src = 0x1370
    AnlgLvl_PauseTrig_When = 0x1371
    AnlgLvl_PauseTrig_Lvl = 0x1369
    AnlgLvl_PauseTrig_Hyst = 0x1368
    AnlgLvl_PauseTrig_Coupling = 0x2236
    AnlgLvl_PauseTrig_DigFltr_Enable = 0x2EF0
    AnlgLvl_PauseTrig_DigFltr_MinPulseWidth = 0x2EF1
    AnlgLvl_PauseTrig_DigFltr_TimebaseSrc = 0x2EF2
    AnlgLvl_PauseTrig_DigFltr_TimebaseRate = 0x2EF3
    AnlgLvl_PauseTrig_DigSync_Enable = 0x2EF4
    AnlgWin_PauseTrig_Src = 0x1373
    AnlgWin_PauseTrig_When = 0x1374
    AnlgWin_PauseTrig_Top = 0x1376
    AnlgWin_PauseTrig_Btm = 0x1375
    AnlgWin_PauseTrig_Coupling = 0x2237
    AnlgWin_PauseTrig_DigFltr_Enable = 0x2EF5
    AnlgWin_PauseTrig_DigFltr_MinPulseWidth = 0x2EF6
    AnlgWin_PauseTrig_DigFltr_TimebaseSrc = 0x2EF7
    AnlgWin_PauseTrig_DigFltr_TimebaseRate = 0x2EF8
    AnlgWin_PauseTrig_DigSync_Enable = 0x2EF9
    DigLvl_PauseTrig_Src = 0x1379
    DigLvl_PauseTrig_When = 0x1380
    DigLvl_PauseTrig_DigFltr_Enable = 0x2228
    DigLvl_PauseTrig_DigFltr_MinPulseWidth = 0x2229
    DigLvl_PauseTrig_DigFltr_TimebaseSrc = 0x222A
    DigLvl_PauseTrig_DigFltr_TimebaseRate = 0x222B
    DigLvl_PauseTrig_DigSync_Enable = 0x222C
    DigPattern_PauseTrig_Src = 0x216F
    DigPattern_PauseTrig_Pattern = 0x2188
    DigPattern_PauseTrig_When = 0x2170
    ArmStartTrig_Type = 0x1414
    ArmStart_Term = 0x2F7F
    DigEdge_ArmStartTrig_Src = 0x1417
    DigEdge_ArmStartTrig_Edge = 0x1415
    DigEdge_ArmStartTrig_DigFltr_Enable = 0x222D
    DigEdge_ArmStartTrig_DigFltr_MinPulseWidth = 0x222E
    DigEdge_ArmStartTrig_DigFltr_TimebaseSrc = 0x222F
    DigEdge_ArmStartTrig_DigFltr_TimebaseRate = 0x2230
    DigEdge_ArmStartTrig_DigSync_Enable = 0x2231
    Trigger_SyncType = 0x2F80
    Watchdog_Timeout = 0x21A9
    WatchdogExpirTrig_Type = 0x21A3
    DigEdge_WatchdogExpirTrig_Src = 0x21A4
    DigEdge_WatchdogExpirTrig_Edge = 0x21A5
    Watchdog_DO_ExpirState = 0x21A7
    Watchdog_HasExpired = 0x21A8
    Write_RelativeTo = 0x190C
    Write_Offset = 0x190D
    Write_RegenMode = 0x1453
    Write_CurrWritePos = 0x1458
    Write_OvercurrentChansExist = 0x29E8
    Write_OvercurrentChans = 0x29E9
    Write_OvertemperatureChansExist = 0x2A84
    Write_OpenCurrentLoopChansExist = 0x29EA
    Write_OpenCurrentLoopChans = 0x29EB
    Write_PowerSupplyFaultChansExist = 0x29EC
    Write_PowerSupplyFaultChans = 0x29ED
    Write_SpaceAvail = 0x1460
    Write_TotalSampPerChanGenerated = 0x192B
    Write_RawDataWidth = 0x217D
    Write_NumChans = 0x217E
    Write_WaitMode = 0x22B1
    Write_SleepTime = 0x22B2
    Write_NextWriteIsLast = 0x296C
    Write_DigitalLines_BytesPerChan = 0x217F
    PhysicalChan_AI_SupportedMeasTypes = 0x2FD7
    PhysicalChan_AI_TermCfgs = 0x2342
    PhysicalChan_AI_InputSrcs = 0x2FD8
    PhysicalChan_AO_SupportedOutputTypes = 0x2FD9
    PhysicalChan_AO_TermCfgs = 0x29A3
    PhysicalChan_AO_ManualControlEnable = 0x2A1E
    PhysicalChan_AO_ManualControl_ShortDetected = 0x2EC3
    PhysicalChan_AO_ManualControlAmplitude = 0x2A1F
    PhysicalChan_AO_ManualControlFreq = 0x2A20
    PhysicalChan_DI_PortWidth = 0x29A4
    PhysicalChan_DI_SampClkSupported = 0x29A5
    PhysicalChan_DI_SampModes = 0x2FE0
    PhysicalChan_DI_ChangeDetectSupported = 0x29A6
    PhysicalChan_DO_PortWidth = 0x29A7
    PhysicalChan_DO_SampClkSupported = 0x29A8
    PhysicalChan_DO_SampModes = 0x2FE1
    PhysicalChan_CI_SupportedMeasTypes = 0x2FDA
    PhysicalChan_CO_SupportedOutputTypes = 0x2FDB
    PhysicalChan_TEDS_MfgID = 0x21DA
    PhysicalChan_TEDS_ModelNum = 0x21DB
    PhysicalChan_TEDS_SerialNum = 0x21DC
    PhysicalChan_TEDS_VersionNum = 0x21DD
    PhysicalChan_TEDS_VersionLetter = 0x21DE
    PhysicalChan_TEDS_BitStream = 0x21DF
    PhysicalChan_TEDS_TemplateIDs = 0x228F
    PersistedTask_Author = 0x22CC
    PersistedTask_AllowInteractiveEditing = 0x22CD
    PersistedTask_AllowInteractiveDeletion = 0x22CE
    PersistedChan_Author = 0x22D0
    PersistedChan_AllowInteractiveEditing = 0x22D1
    PersistedChan_AllowInteractiveDeletion = 0x22D2
    PersistedScale_Author = 0x22D4
    PersistedScale_AllowInteractiveEditing = 0x22D5
    PersistedScale_AllowInteractiveDeletion = 0x22D6
    ReadWaitMode = Read_WaitMode

    Val_Task_Start = 0
    Val_Task_Stop = 1
    Val_Task_Verify = 2
    Val_Task_Commit = 3
    Val_Task_Reserve = 4
    Val_Task_Unreserve = 5
    Val_Task_Abort = 6
    Val_SynchronousEventCallbacks = (1<<0)
    Val_Acquired_Into_Buffer = 1
    Val_Transferred_From_Buffer = 2
    Val_ResetTimer = 0
    Val_ClearExpiration = 1
    Val_ChanPerLine = 0
    Val_ChanForAllLines = 1
    Val_GroupByChannel = 0
    Val_GroupByScanNumber = 1
    Val_DoNotInvertPolarity = 0
    Val_InvertPolarity = 1
    Val_Action_Commit = 0
    Val_Action_Cancel = 1
    Val_AdvanceTrigger = 12488
    Val_Rising = 10280
    Val_Falling = 10171
    Val_PathStatus_Available = 10431
    Val_PathStatus_AlreadyExists = 10432
    Val_PathStatus_Unsupported = 10433
    Val_PathStatus_ChannelInUse = 10434
    Val_PathStatus_SourceChannelConflict = 10435
    Val_PathStatus_ChannelReservedForRouting = 10436
    Val_DegC = 10143
    Val_DegF = 10144
    Val_Kelvins = 10325
    Val_DegR = 10145
    Val_High = 10192
    Val_Low = 10214
    Val_Tristate = 10310
    Val_PullUp = 15950
    Val_PullDown = 15951
    Val_ChannelVoltage = 0
    Val_ChannelCurrent = 1
    Val_Open = 10437
    Val_Closed = 10438
    Val_Loopback0 = 0
    Val_Loopback180 = 1
    Val_Ground = 2
    Val_Cfg_Default = -1
    Val_Default = -1
    Val_WaitInfinitely = -1.0
    Val_Auto = -1
    Val_Save_Overwrite = (1<<0)
    Val_Save_AllowInteractiveEditing = (1<<1)
    Val_Save_AllowInteractiveDeletion = (1<<2)
    Val_Bit_TriggerUsageTypes_Advance = (1<<0)
    Val_Bit_TriggerUsageTypes_Pause = (1<<1)
    Val_Bit_TriggerUsageTypes_Reference = (1<<2)
    Val_Bit_TriggerUsageTypes_Start = (1<<3)
    Val_Bit_TriggerUsageTypes_Handshake = (1<<4)
    Val_Bit_TriggerUsageTypes_ArmStart = (1<<5)
    Val_Bit_CouplingTypes_AC = (1<<0)
    Val_Bit_CouplingTypes_DC = (1<<1)
    Val_Bit_CouplingTypes_Ground = (1<<2)
    Val_Bit_CouplingTypes_HFReject = (1<<3)
    Val_Bit_CouplingTypes_LFReject = (1<<4)
    Val_Bit_CouplingTypes_NoiseReject = (1<<5)
    Val_Bit_TermCfg_RSE = (1<<0)
    Val_Bit_TermCfg_NRSE = (1<<1)
    Val_Bit_TermCfg_Diff = (1<<2)
    Val_Bit_TermCfg_PseudoDIFF = (1<<3)
    Val_4Wire = 4
    Val_5Wire = 5
    Val_HighResolution = 10195
    Val_HighSpeed = 14712
    Val_Best50HzRejection = 14713
    Val_Best60HzRejection = 14714
    Val_Custom = 10137
    Val_Voltage = 10322
    Val_VoltageRMS = 10350
    Val_Current = 10134
    Val_CurrentRMS = 10351
    Val_Voltage_CustomWithExcitation = 10323
    Val_Bridge = 15908
    Val_Freq_Voltage = 10181
    Val_Resistance = 10278
    Val_Temp_TC = 10303
    Val_Temp_Thrmstr = 10302
    Val_Temp_RTD = 10301
    Val_Temp_BuiltInSensor = 10311
    Val_Strain_Gage = 10300
    Val_Position_LVDT = 10352
    Val_Position_RVDT = 10353
    Val_Position_EddyCurrentProximityProbe = 14835
    Val_Accelerometer = 10356
    Val_Force_Bridge = 15899
    Val_Force_IEPESensor = 15895
    Val_Pressure_Bridge = 15902
    Val_SoundPressure_Microphone = 10354
    Val_Torque_Bridge = 15905
    Val_TEDS_Sensor = 12531
    Val_ZeroVolts = 12526
    Val_HighImpedance = 12527
    Val_MaintainExistingValue = 12528
    Val_Voltage = 10322
    Val_Current = 10134
    Val_FuncGen = 14750
    Val_mVoltsPerG = 12509
    Val_VoltsPerG = 12510
    Val_AccelUnit_g = 10186
    Val_MetersPerSecondSquared = 12470
    Val_InchesPerSecondSquared = 12471
    Val_FromCustomScale = 10065
    Val_FiniteSamps = 10178
    Val_ContSamps = 10123
    Val_HWTimedSinglePoint = 12522
    Val_AboveLvl = 10093
    Val_BelowLvl = 10107
    Val_Degrees = 10146
    Val_Radians = 10273
    Val_FromCustomScale = 10065
    Val_Degrees = 10146
    Val_Radians = 10273
    Val_Ticks = 10304
    Val_FromCustomScale = 10065
    Val_None = 10230
    Val_Once = 10244
    Val_EverySample = 10164
    Val_NoAction = 10227
    Val_BreakBeforeMake = 10110
    Val_FullBridge = 10182
    Val_HalfBridge = 10187
    Val_QuarterBridge = 10270
    Val_NoBridge = 10228
    Val_VoltsPerVolt = 15896
    Val_mVoltsPerVolt = 15897
    Val_Newtons = 15875
    Val_Pounds = 15876
    Val_KilogramForce = 15877
    Val_Pascals = 10081
    Val_PoundsPerSquareInch = 15879
    Val_Bar = 15880
    Val_NewtonMeters = 15881
    Val_InchOunces = 15882
    Val_InchPounds = 15883
    Val_FootPounds = 15884
    Val_VoltsPerVolt = 15896
    Val_mVoltsPerVolt = 15897
    Val_FromCustomScale = 10065
    Val_FromTEDS = 12516
    Val_PCI = 12582
    Val_PCIe = 13612
    Val_PXI = 12583
    Val_PXIe = 14706
    Val_SCXI = 12584
    Val_SCC = 14707
    Val_PCCard = 12585
    Val_USB = 12586
    Val_CompactDAQ = 14637
    Val_TCPIP = 14828
    Val_Unknown = 12588
    Val_SwitchBlock = 15870
    Val_CountEdges = 10125
    Val_Freq = 10179
    Val_Period = 10256
    Val_PulseWidth = 10359
    Val_SemiPeriod = 10289
    Val_PulseFrequency = 15864
    Val_PulseTime = 15865
    Val_PulseTicks = 15866
    Val_Position_AngEncoder = 10360
    Val_Position_LinEncoder = 10361
    Val_TwoEdgeSep = 10267
    Val_GPS_Timestamp = 10362
    Val_BuiltIn = 10200
    Val_ConstVal = 10116
    Val_Chan = 10113
    Val_Pulse_Time = 10269
    Val_Pulse_Freq = 10119
    Val_Pulse_Ticks = 10268
    Val_AI = 10100
    Val_AO = 10102
    Val_DI = 10151
    Val_DO = 10153
    Val_CI = 10131
    Val_CO = 10132
    Val_Unconstrained = 14708
    Val_FixedHighFreq = 14709
    Val_FixedLowFreq = 14710
    Val_Fixed50PercentDutyCycle = 14711
    Val_CountUp = 10128
    Val_CountDown = 10124
    Val_ExtControlled = 10326
    Val_LowFreq1Ctr = 10105
    Val_HighFreq2Ctr = 10157
    Val_LargeRng2Ctr = 10205
    Val_AC = 10045
    Val_DC = 10050
    Val_GND = 10066
    Val_AC = 10045
    Val_DC = 10050
    Val_Internal = 10200
    Val_External = 10167
    Val_Amps = 10342
    Val_FromCustomScale = 10065
    Val_FromTEDS = 12516
    Val_Amps = 10342
    Val_FromCustomScale = 10065
    Val_RightJustified = 10279
    Val_LeftJustified = 10209
    Val_DMA = 10054
    Val_Interrupts = 10204
    Val_ProgrammedIO = 10264
    Val_USBbulk = 12590
    Val_OnbrdMemMoreThanHalfFull = 10237
    Val_OnbrdMemFull = 10236
    Val_OnbrdMemCustomThreshold = 12577
    Val_ActiveDrive = 12573
    Val_OpenCollector = 12574
    Val_High = 10192
    Val_Low = 10214
    Val_Tristate = 10310
    Val_NoChange = 10160
    Val_PatternMatches = 10254
    Val_PatternDoesNotMatch = 10253
    Val_SampClkPeriods = 10286
    Val_Seconds = 10364
    Val_Ticks = 10304
    Val_Seconds = 10364
    Val_Ticks = 10304
    Val_Seconds = 10364
    Val_mVoltsPerMil = 14836
    Val_VoltsPerMil = 14837
    Val_mVoltsPerMillimeter = 14838
    Val_VoltsPerMillimeter = 14839
    Val_mVoltsPerMicron = 14840
    Val_Rising = 10280
    Val_Falling = 10171
    Val_X1 = 10090
    Val_X2 = 10091
    Val_X4 = 10092
    Val_TwoPulseCounting = 10313
    Val_AHighBHigh = 10040
    Val_AHighBLow = 10041
    Val_ALowBHigh = 10042
    Val_ALowBLow = 10043
    Val_DC = 10050
    Val_AC = 10045
    Val_Internal = 10200
    Val_External = 10167
    Val_None = 10230
    Val_Voltage = 10322
    Val_Current = 10134
    Val_Pulse = 10265
    Val_Toggle = 10307
    Val_Pulse = 10265
    Val_Lvl = 10210
    Val_Interlocked = 12549
    Val_Pulse = 10265
    Val_mVoltsPerNewton = 15891
    Val_mVoltsPerPound = 15892
    Val_Newtons = 15875
    Val_Pounds = 15876
    Val_KilogramForce = 15877
    Val_FromCustomScale = 10065
    Val_Hz = 10373
    Val_FromCustomScale = 10065
    Val_Hz = 10373
    Val_Hz = 10373
    Val_Ticks = 10304
    Val_FromCustomScale = 10065
    Val_Sine = 14751
    Val_Triangle = 14752
    Val_Square = 14753
    Val_Sawtooth = 14754
    Val_IRIGB = 10070
    Val_PPS = 10080
    Val_None = 10230
    Val_Immediate = 10198
    Val_WaitForHandshakeTriggerAssert = 12550
    Val_WaitForHandshakeTriggerDeassert = 12551
    Val_OnBrdMemMoreThanHalfFull = 10237
    Val_OnBrdMemNotEmpty = 10241
    Val_OnbrdMemCustomThreshold = 12577
    Val_WhenAcqComplete = 12546
    Val_RSE = 10083
    Val_NRSE = 10078
    Val_Diff = 10106
    Val_PseudoDiff = 12529
    Val_mVoltsPerVoltPerMillimeter = 12506
    Val_mVoltsPerVoltPerMilliInch = 12505
    Val_Meters = 10219
    Val_Inches = 10379
    Val_FromCustomScale = 10065
    Val_Meters = 10219
    Val_Inches = 10379
    Val_Ticks = 10304
    Val_FromCustomScale = 10065
    Val_High = 10192
    Val_Low = 10214
    Val_Off = 10231
    Val_Log = 15844
    Val_LogAndRead = 15842
    Val_Open = 10437
    Val_OpenOrCreate = 15846
    Val_CreateOrReplace = 15847
    Val_Create = 15848
    Val_2point5V = 14620
    Val_3point3V = 14621
    Val_5V = 14619
    Val_SameAsSampTimebase = 10284
    Val_100MHzTimebase = 15857
    Val_SameAsMasterTimebase = 10282
    Val_20MHzTimebase = 12537
    Val_80MHzTimebase = 14636
    Val_AM = 14756
    Val_FM = 14757
    Val_None = 10230
    Val_OnBrdMemEmpty = 10235
    Val_OnBrdMemHalfFullOrLess = 10239
    Val_OnBrdMemNotFull = 10242
    Val_RSE = 10083
    Val_Diff = 10106
    Val_PseudoDiff = 12529
    Val_StopTaskAndError = 15862
    Val_IgnoreOverruns = 15863
    Val_OverwriteUnreadSamps = 10252
    Val_DoNotOverwriteUnreadSamps = 10159
    Val_ActiveHigh = 10095
    Val_ActiveLow = 10096
    Val_Pascals = 10081
    Val_PoundsPerSquareInch = 15879
    Val_Bar = 15880
    Val_FromCustomScale = 10065
    Val_MSeriesDAQ = 14643
    Val_XSeriesDAQ = 15858
    Val_ESeriesDAQ = 14642
    Val_SSeriesDAQ = 14644
    Val_BSeriesDAQ = 14662
    Val_SCSeriesDAQ = 14645
    Val_USBDAQ = 14646
    Val_AOSeries = 14647
    Val_DigitalIO = 14648
    Val_TIOSeries = 14661
    Val_DynamicSignalAcquisition = 14649
    Val_Switches = 14650
    Val_CompactDAQChassis = 14658
    Val_CSeriesModule = 14659
    Val_SCXIModule = 14660
    Val_SCCConnectorBlock = 14704
    Val_SCCModule = 14705
    Val_NIELVIS = 14755
    Val_NetworkDAQ = 14829
    Val_SCExpress = 15886
    Val_Unknown = 12588
    Val_Pt3750 = 12481
    Val_Pt3851 = 10071
    Val_Pt3911 = 12482
    Val_Pt3916 = 10069
    Val_Pt3920 = 10053
    Val_Pt3928 = 12483
    Val_Custom = 10137
    Val_mVoltsPerVoltPerDegree = 12507
    Val_mVoltsPerVoltPerRadian = 12508
    Val_None = 10230
    Val_LosslessPacking = 12555
    Val_LossyLSBRemoval = 12556
    Val_FirstSample = 10424
    Val_CurrReadPos = 10425
    Val_RefTrig = 10426
    Val_FirstPretrigSamp = 10427
    Val_MostRecentSamp = 10428
    Val_AllowRegen = 10097
    Val_DoNotAllowRegen = 10158
    Val_2Wire = 2
    Val_3Wire = 3
    Val_4Wire = 4
    Val_Ohms = 10384
    Val_FromCustomScale = 10065
    Val_FromTEDS = 12516
    Val_Ohms = 10384
    Val_FromCustomScale = 10065
    Val_Bits = 10109
    Val_SCXI1124Range0to1V = 14629
    Val_SCXI1124Range0to5V = 14630
    Val_SCXI1124Range0to10V = 14631
    Val_SCXI1124RangeNeg1to1V = 14632
    Val_SCXI1124RangeNeg5to5V = 14633
    Val_SCXI1124RangeNeg10to10V = 14634
    Val_SCXI1124Range0to20mA = 14635
    Val_SampClkActiveEdge = 14617
    Val_SampClkInactiveEdge = 14618
    Val_HandshakeTriggerAsserts = 12552
    Val_HandshakeTriggerDeasserts = 12553
    Val_SampClk = 10388
    Val_BurstHandshake = 12548
    Val_Handshake = 10389
    Val_Implicit = 10451
    Val_OnDemand = 10390
    Val_ChangeDetection = 12504
    Val_PipelinedSampClk = 14668
    Val_Linear = 10447
    Val_MapRanges = 10448
    Val_Polynomial = 10449
    Val_Table = 10450
    Val_Polynomial = 10449
    Val_Table = 10450
    Val_Polynomial = 10449
    Val_Table = 10450
    Val_None = 10230
    Val_None = 10230
    Val_TwoPointLinear = 15898
    Val_Table = 10450
    Val_Polynomial = 10449
    Val_A = 12513
    Val_B = 12514
    Val_AandB = 12515
    Val_R1 = 12465
    Val_R2 = 12466
    Val_R3 = 12467
    Val_R4 = 14813
    Val_None = 10230
    Val_AIConvertClock = 12484
    Val_10MHzRefClock = 12536
    Val_20MHzTimebaseClock = 12486
    Val_SampleClock = 12487
    Val_AdvanceTrigger = 12488
    Val_ReferenceTrigger = 12490
    Val_StartTrigger = 12491
    Val_AdvCmpltEvent = 12492
    Val_AIHoldCmpltEvent = 12493
    Val_CounterOutputEvent = 12494
    Val_ChangeDetectionEvent = 12511
    Val_WDTExpiredEvent = 12512
    Val_SampleCompleteEvent = 12530
    Val_CounterOutputEvent = 12494
    Val_ChangeDetectionEvent = 12511
    Val_SampleClock = 12487
    Val_RisingSlope = 10280
    Val_FallingSlope = 10171
    Val_Pascals = 10081
    Val_FromCustomScale = 10065
    Val_Internal = 10200
    Val_External = 10167
    Val_FullBridgeI = 10183
    Val_FullBridgeII = 10184
    Val_FullBridgeIII = 10185
    Val_HalfBridgeI = 10188
    Val_HalfBridgeII = 10189
    Val_QuarterBridgeI = 10271
    Val_QuarterBridgeII = 10272
    Val_Strain = 10299
    Val_FromCustomScale = 10065
    Val_Finite = 10172
    Val_Cont = 10117
    Val_Source = 10439
    Val_Load = 10440
    Val_ReservedForRouting = 10441
    Val_None = 10230
    Val_Master = 15888
    Val_Slave = 15889
    Val_FromCustomScale = 10065
    Val_FromTEDS = 12516
    Val_DegC = 10143
    Val_DegF = 10144
    Val_Kelvins = 10325
    Val_DegR = 10145
    Val_FromCustomScale = 10065
    Val_J_Type_TC = 10072
    Val_K_Type_TC = 10073
    Val_N_Type_TC = 10077
    Val_R_Type_TC = 10082
    Val_S_Type_TC = 10085
    Val_T_Type_TC = 10086
    Val_B_Type_TC = 10047
    Val_E_Type_TC = 10055
    Val_Seconds = 10364
    Val_FromCustomScale = 10065
    Val_Seconds = 10364
    Val_Seconds = 10364
    Val_Ticks = 10304
    Val_FromCustomScale = 10065
    Val_SingleCycle = 14613
    Val_Multicycle = 14614
    Val_NewtonMeters = 15881
    Val_InchOunces = 15882
    Val_InchPounds = 15883
    Val_FootPounds = 15884
    Val_FromCustomScale = 10065
    Val_DigEdge = 10150
    Val_None = 10230
    Val_DigEdge = 10150
    Val_Software = 10292
    Val_None = 10230
    Val_AnlgLvl = 10101
    Val_AnlgWin = 10103
    Val_DigLvl = 10152
    Val_DigPattern = 10398
    Val_None = 10230
    Val_AnlgEdge = 10099
    Val_DigEdge = 10150
    Val_DigPattern = 10398
    Val_AnlgWin = 10103
    Val_None = 10230
    Val_Interlocked = 12549
    Val_None = 10230
    Val_HaltOutputAndError = 14615
    Val_PauseUntilDataAvailable = 14616
    Val_Volts = 10348
    Val_Amps = 10342
    Val_DegF = 10144
    Val_DegC = 10143
    Val_DegR = 10145
    Val_Kelvins = 10325
    Val_Strain = 10299
    Val_Ohms = 10384
    Val_Hz = 10373
    Val_Seconds = 10364
    Val_Meters = 10219
    Val_Inches = 10379
    Val_Degrees = 10146
    Val_Radians = 10273
    Val_Ticks = 10304
    Val_g = 10186
    Val_MetersPerSecondSquared = 12470
    Val_Pascals = 10081
    Val_Newtons = 15875
    Val_Pounds = 15876
    Val_KilogramForce = 15877
    Val_PoundsPerSquareInch = 15879
    Val_Bar = 15880
    Val_NewtonMeters = 15881
    Val_InchOunces = 15882
    Val_InchPounds = 15883
    Val_FootPounds = 15884
    Val_VoltsPerVolt = 15896
    Val_mVoltsPerVolt = 15897
    Val_FromTEDS = 12516
    Val_Volts = 10348
    Val_FromCustomScale = 10065
    Val_FromTEDS = 12516
    Val_Volts = 10348
    Val_FromCustomScale = 10065
    Val_WaitForInterrupt = 12523
    Val_Poll = 12524
    Val_Yield = 12525
    Val_Sleep = 12547
    Val_Poll = 12524
    Val_Yield = 12525
    Val_Sleep = 12547
    Val_WaitForInterrupt = 12523
    Val_Poll = 12524
    Val_WaitForInterrupt = 12523
    Val_Poll = 12524
    Val_EnteringWin = 10163
    Val_LeavingWin = 10208
    Val_InsideWin = 10199
    Val_OutsideWin = 10251
    Val_WriteToEEPROM = 12538
    Val_WriteToPROM = 12539
    Val_DoNotWrite = 12540
    Val_FirstSample = 10424
    Val_CurrWritePos = 10430
    Val_Switch_Topology_1127_Independent = "1127/Independent"
    Val_Switch_Topology_1128_Independent = "1128/Independent"
    Val_Switch_Topology_1130_Independent = "1130/Independent"
    Val_Switch_Topology_1160_16_SPDT = "1160/16-SPDT"
    Val_Switch_Topology_1161_8_SPDT = "1161/8-SPDT"
    Val_Switch_Topology_1166_32_SPDT = "1166/32-SPDT"
    Val_Switch_Topology_1166_16_DPDT = "1166/16-DPDT"
    Val_Switch_Topology_1167_Independent = "1167/Independent"
    Val_Switch_Topology_1169_100_SPST = "1169/100-SPST"
    Val_Switch_Topology_1169_50_DPST = "1169/50-DPST"
    Val_Switch_Topology_1192_8_SPDT = "1192/8-SPDT"
    Val_Switch_Topology_1193_Independent = "1193/Independent"
    Val_Switch_Topology_2510_Independent = "2510/Independent"
    Val_Switch_Topology_2512_Independent = "2512/Independent"
    Val_Switch_Topology_2514_Independent = "2514/Independent"
    Val_Switch_Topology_2515_Independent = "2515/Independent"
    Val_Switch_Topology_2527_Independent = "2527/Independent"
    Val_Switch_Topology_2530_Independent = "2530/Independent"
    Val_Switch_Topology_2548_4_SPDT = "2548/4-SPDT"
    Val_Switch_Topology_2558_4_SPDT = "2558/4-SPDT"
    Val_Switch_Topology_2564_16_SPST = "2564/16-SPST"
    Val_Switch_Topology_2564_8_DPST = "2564/8-DPST"
    Val_Switch_Topology_2565_16_SPST = "2565/16-SPST"
    Val_Switch_Topology_2566_16_SPDT = "2566/16-SPDT"
    Val_Switch_Topology_2566_8_DPDT = "2566/8-DPDT"
    Val_Switch_Topology_2567_Independent = "2567/Independent"
    Val_Switch_Topology_2568_31_SPST = "2568/31-SPST"
    Val_Switch_Topology_2568_15_DPST = "2568/15-DPST"
    Val_Switch_Topology_2569_100_SPST = "2569/100-SPST"
    Val_Switch_Topology_2569_50_DPST = "2569/50-DPST"
    Val_Switch_Topology_2570_40_SPDT = "2570/40-SPDT"
    Val_Switch_Topology_2570_20_DPDT = "2570/20-DPDT"
    Val_Switch_Topology_2571_66_SPDT = "2571/66-SPDT"
    Val_Switch_Topology_2576_Independent = "2576/Independent"
    Val_Switch_Topology_2584_Independent = "2584/Independent"
    Val_Switch_Topology_2586_10_SPST = "2586/10-SPST"
    Val_Switch_Topology_2586_5_DPST = "2586/5-DPST"
    Val_Switch_Topology_2593_Independent = "2593/Independent"
    Val_Switch_Topology_2599_2_SPDT = "2599/2-SPDT"

import ctypes as ct

class DoNothing(object):

    def from_param(self, param):
        return param

class Types(metaclass=RichEnum):

    _ = DoNothing()

    void_p = ct.c_void_p

    TaskHandle = ct.c_void_p
    #TaskHandle = ct.c_uint32
    bool32 = ct.c_uint32

    string = ct.c_char_p

    int8 = ct.c_int8
    uInt8 = ct.c_uint8

    int16 = ct.c_int16
    uInt16 = ct.c_uint16

    int32 = ct.c_int32
    uInt32 = ct.c_uint32

    int64 = ct.c_int64
    uInt64 = ct.c_uint64

    float32 = ct.c_float
    float64 = ct.c_double
