import unittest

from learnsprout.errors import LearnSproutClientException
from learnsprout.client import LearnSproutClient
from learnsprout.resources import Course
from learnsprout.tests import sample_org_id, sample_school_id

class TestCourses(unittest.TestCase):
  """
    Tests for Course resources.
  """
  def setUp(self):
    """ Set up course tests. """
    lsc = LearnSproutClient()
    self.org = lsc.orgs.get(sample_org_id)
    school = self.org.schools.get(sample_school_id)
    self.courses_resource = school.courses

  def ensure_members(self, course):
    """ Ensure that a course has all the members it should. """
    self.assertTrue(hasattr(course, "school"))
    self.assertTrue(hasattr(course, "time_updated"))
    self.assertTrue(hasattr(course, "name"))
    self.assertTrue(hasattr(course, "number"))
    self.assertTrue(hasattr(course, "ls_id"))

  def test_list_courses_page(self):
    """ List a set of courses. """
    courses = self.courses_resource.iter_all()
    self.assertEqual(courses.is_empty, False)
    for course in courses:
      self.ensure_members(course)

  def test_get_course_by_id(self):
    """ Get an individual course by id. """
    course = self.courses_resource.iter_all().next()
    id1 = course.ls_id

    course = self.courses_resource.get(id1)
    self.assertIsInstance(course, Course)
    self.ensure_members(course)
    self.assertEqual(course.ls_id, id1)

class TestCoursesOrgRoute(TestCourses):
  """
    Tests for accessing Course resources through organizations.
  """
  def setUp(self):
    super(TestCoursesOrgRoute, self).setUp()
    self.courses_resource = self.org.courses

if __name__ == '__main__':
  unittest.main()

