learnsprout-python
==================

For best readability, open this document in a Markdown viewer

`learnsprout-python` is a simple python library for access to student information via the LearnSprout REST API.  You can view documentation for the REST API at LearnSprout's [interactive console](http://developers.learnsprout.com/interactive)

## Installation

    pip install learnsprout

#### Dependencies

[requests - HTTP for Humans](http://docs.python-requests.org)

## Using the client

The `LearnSproutClient` only requires an `apikey` to use. [Requesting one](http://developers.learnsprout.com) for your own use is simple.  There is also a public sample API which only has access to sample data.

    from learnsprout.client import LearnSproutClient
    client = LearnSproutClient("fcb8534c-e4ee-4e02-8b22-9328db1dac18")

Alternatively, you can provide OS environment variables

    export LEARNSPROUT_APIKEY="fcb8534c-e4ee-4e02-8b22-9328db1dac18"

then in Python, the `apikey` will be inferred automagically from the var above

    client = LearnSproutClient()

### Organizations

Organizations are the root level element.  Organizations can be accessed off the root level.

    orgs = client.organizations.iter_all()


This will return an IterableResult which can be iterated over for the resources.

    orgs = client.orgs.iter_all()
    for org in orgs:
        print org


Resources have the same properties as listed in the REST API, with the exception of the *id* which has been renamed *ls_id* to not collide with Python ids.

You can grab individual resources out of the IterableResult by calling next().

    org = orgs.next()

If you know the LearnSprout id of the specific resource you're looking for, you can skip iterating and grab the instance straight from the collection.

    org = client.orgs.get("506b8b1f780aa79602388b42")

### Schools

Schools are subresources of organizations.  Subresources are available off of resource instances.

    org = orgs.next()
    schools = org.schools.iter_all()

### Pagination

Note that schools, like some other resources, are paginated.  However, when iterating over a IterableResult, if you exhaust all the elements in the page, the client will fetch additional results so you should not need to worry about paging.

### Partials
LearnSprout also supports grabbing resources that have been updated after a certain timestamp. ResourceInstances have a *time_updated* property. Specifying that as an argument to iter_all() will only return ResourceInstances with time_updated greater than the value provided.

    schools_resource = org.schools
    time_since = schools_resource.iter_all().next().time_updated
    schools_resource.iter_all(since=time_since)

### Other supported resources

* Courses
* Sections
* Students
* Teachers
* Terms
* Attendance
* Course Grades
* Enrollment
* Periods
* Attendance Codes

### Terms

When accessing the terms collection off of a School, there is a special ResourceInstance available off the terms collection.  The *current* property refers to the current term in the school.
