import unittest

from learnsprout.errors import LearnSproutClientException
from learnsprout.client import LearnSproutClient
from learnsprout.resources import CourseGrade
from learnsprout.tests import sample_org_id, sample_school_id

class TestCourseGrade(unittest.TestCase):
  """ Tests for Course_Grade resources.  """
  def setUp(self):
    """ Set up Course_Grade tests. """
    lsc = LearnSproutClient()
    self.org = lsc.orgs.get(sample_org_id)
    school = self.org.schools.get(sample_school_id)
    self.course_grade_resource = school.course_grade

  def ensure_members(self, course_grade):
    """ Ensure a Course_Grade has the expected members. """
    self.assertTrue(hasattr(course_grade, "ls_id"))
    self.assertTrue(hasattr(course_grade, "school"))
    self.assertTrue(hasattr(course_grade, "section"))
    self.assertTrue(hasattr(course_grade, "student"))
    self.assertTrue(hasattr(course_grade, "start_date"))
    self.assertTrue(hasattr(course_grade, "end_date"))
    self.assertTrue(hasattr(course_grade, "grade"))
    self.assertTrue(hasattr(course_grade, "percent"))
    self.assertTrue(hasattr(course_grade, "time_updated"))

  def ensure_member_types(self, a):
    self.assertIsInstance(a.start_date, basestring)
    self.assertIsInstance(a.end_date, basestring)
    self.assertIsInstance(a.grade, basestring)
    self.assertIsInstance(a.percent, float)
    self.assertIsInstance(a.time_updated, int)

  def test_has_members(self):
    """ Check a single course_grade record. """
    a = self.course_grade_resource.iter_all().next()
    self.assertIsInstance(a, CourseGrade)
    self.ensure_members(a)
    self.ensure_member_types(a)

  def test_section_course_grade(self):
    """ Check an entire section's course_grade records for consistency """
    a = self.course_grade_resource.iter_all().next()
    section_id = a.section['id']
    school_id = a.school['id']
    school = self.org.schools.get(school_id)
    section  = school.sections.get(section_id)
    section_course_grade = section.course_grade.iter_all()
    section_ids = set()
    school_ids = set()
    for rec in section_course_grade:
        section_ids.add(rec.section['id'])
        school_ids.add(rec.school['id'])
    self.assertEquals(1, len(section_ids)) # There should only be one section ID when requesting a section's course_grade
    self.assertEquals(1, len(school_ids)) # Same for schools

class TestCourseGradeOrgRoute(TestCourseGrade):
  """
    Tests for Course_Grade resources accessed via the organization routes.
  """
  def setUp(self):
    super(TestCourseGradeOrgRoute, self).setUp()
    self.course_grade_resource = self.org.course_grade

if __name__ == '__main__':
  unittest.main()
