import unittest

from learnsprout.resources import resource

class FakeIterableResult(object):

  def __init__(self, owning_client, instance_from_json, uri, params):
    self.params = params

resource.IterableResult = FakeIterableResult

class TestIterAll(resource.ResourceCollection):
  owning_client = instance_from_json = uri = 1

  def __init__(self):
    pass

class TestResource(unittest.TestCase):

  def test_iter_all(self):
    """ Ensure iter_all functionality """
    client = TestIterAll()
    result = client.iter_all(params = {'foo': 1})
    self.assertEquals(result.params, {'foo': 1})
    result2 = client.iter_all(params = {'bar': 1})
    self.assertEquals(result2.params, {'bar': 1})

    result3 = client.iter_all(since = 1)
    self.assertEquals(result3.params, {'since': 1})
    result4 = client.iter_all(since = 2)
    self.assertEquals(result4.params, {'since': 2})
    result5 = client.iter_all()
    self.assertEquals(result5.params, {})

if __name__ == '__main__':
  unittest.main()
