import unittest

from learnsprout.errors import LearnSproutClientException
from learnsprout.client import LearnSproutClient
from learnsprout.resources import Student
from learnsprout.tests import sample_org_id, sample_school_id

class TestStudents(unittest.TestCase):
  """
    Tests for student resources.
  """
  def setUp(self):
    """ Set up for student tests """
    lsc = LearnSproutClient()
    self.org = lsc.orgs.get(sample_org_id)
    school = self.org.schools.get(sample_school_id)
    self.students_resource = school.students

  def ensure_members(self, student):
    """ Ensure that the student has all the members it should. """
    self.assertTrue(hasattr(student, "last_name"))
    self.assertTrue(hasattr(student, "grade"))
    self.assertTrue(hasattr(student, "address"))
    self.assertTrue(hasattr(student, "school"))
    self.assertTrue(hasattr(student, "number"))
    self.assertTrue(hasattr(student, "phone"))
    self.assertTrue(hasattr(student, "birthday"))
    self.assertTrue(hasattr(student, "ls_id"))
    self.assertTrue(hasattr(student, "first_name"))
    self.assertTrue(hasattr(student, "time_updated"))
    self.assertTrue(hasattr(student, "middle_name"))
    self.assertTrue(hasattr(student, "gender"))
    self.assertTrue(hasattr(student, "exit_date"))
    self.assertTrue(hasattr(student, "entry_date"))

  def test_list_students(self):
    """ List a number of students. """
    students = self.students_resource.iter_all()
    self.assertEqual(students.is_empty, False)
    for count, student in enumerate(students, 1):
      self.ensure_members(student)
    self.assertGreater(count, 50)

  def test_get_student_by_id(self):
    """ Get an individual student by id. """
    student = self.students_resource.iter_all().next()
    id1 = student.ls_id

    student = self.students_resource.get(id1)
    self.assertIsInstance(student, Student)
    self.ensure_members(student)
    self.assertEqual(student.ls_id, id1)

class TestStudentsOrgRoute(TestStudents):
  """
    Tests for student resources that are accessed through the organization routes.
  """
  def setUp(self):
    super(TestStudentsOrgRoute, self).setUp()
    self.students_resource = self.org.students

if __name__ == '__main__':
  unittest.main()

