import unittest

from learnsprout.errors import LearnSproutClientException
from learnsprout.client import LearnSproutClient
from learnsprout.resources import Term
from learnsprout.tests import sample_org_id, sample_school_id

class TestTerms(unittest.TestCase):
  def setUp(self):
    lsc = LearnSproutClient()
    self.org = lsc.orgs.get(sample_org_id)
    self.terms_resource = self.org.terms

  def ensure_members(self, term):
    self.assertTrue(hasattr(term, "school"))
    self.assertTrue(hasattr(term, "time_updated"))
    self.assertTrue(hasattr(term, "name"))
    self.assertTrue(hasattr(term, "end_date"))
    self.assertTrue(hasattr(term, "start_date"))
    self.assertTrue(hasattr(term, "sections"))
    self.assertTrue(hasattr(term, "ls_id"))

  def test_list_terms_page(self):
    terms = self.terms_resource.iter_all()
    self.assertEqual(terms.is_empty, False)
    for term in terms:
      self.ensure_members(term)

  def test_get_term_by_id(self):
    term = self.terms_resource.iter_all().next()
    id1 = term.ls_id

    term = self.terms_resource.get(id1)
    self.assertIsInstance(term, Term)
    self.ensure_members(term)
    self.assertEqual(term.ls_id, id1)

class TestTermsSchoolRoute(TestTerms):
  def setUp(self):
    super(TestTermsSchoolRoute, self).setUp()
    school = self.org.schools.get(sample_school_id)
    self.terms_resource = school.terms

  def test_get_current_term_by_id(self):
    term = self.terms_resource.get("current")
    self.assertIsInstance(term, Term)
    self.ensure_members(term)

  def test_get_current_term(self):
    term_by_id = self.terms_resource.get("current")
    term = self.terms_resource.current
    self.assertIsInstance(term, Term)
    self.ensure_members(term)
    self.assertEqual(term_by_id.ls_id, term.ls_id)

if __name__ == '__main__':
  unittest.main()

