class MissingDependency(Exception):
  """ Class for missing dependencies."""
  pass

class LearnSproutException(Exception):
  """Base class for errors thrown by the **LearnSproutClient**."""
  pass

class MissingAPIConfig(LearnSproutException):
  """ Class for programmer errors relating to program config. """
  pass

class UnsupportedRoute(LearnSproutException):
  """ Class for features that are not supported """
  pass

class BadRecord(LearnSproutException):
  """ Class for record that cannot be interpreted. """
  pass

class LearnSproutHTTPException(LearnSproutException):
  """
    Class for HTTP errors thrown by the **LearnSproutClient**. These are for non-200 responses.
  """
  name = "LS Error"
  def __init__(self, status_code=400, message="", uri=""):
    super(LearnSproutHTTPException, self).__init__(message)
    self.status_code = status_code
    self.uri = uri

  def __str__(self):
    return "%s: HTTP Status %s, %s, %s" % (self.name, self.status_code, self.message, self.uri)

class LearnSproutClientException(LearnSproutHTTPException):
  """ Class for HTTP 4xx errors thrown by the **LearnSproutClient**. """
  name = "LS Client Error"

class LearnSproutServerException(LearnSproutHTTPException):
  """ Class for HTTP 5xx errors thrown by the **LearnSproutClient**. """
  name = "LS Server Error"

def error_from_json(err_json):
  """
    Generates the appropriate error based on a response's status code.
  """
  if "status_code" in err_json:
    error_code = err_json["status_code"]
    if error_code >= 400 and error_code < 500:
      return LearnSproutClientException(error_code, err_json["message"], err_json["uri"])
    elif error_code >= 500:
      return LearnSproutServerException(error_code, err_json["message"], err_json["uri"])
