from resource import ResourceInstance, ResourceCollection

class Student(ResourceInstance):
  def to_json_obj(self):
    """
      Returns a dictionary representation of this object that can be dumped to JSON.
    """
    d = self.__dict__.copy()
    d["id"] = d["ls_id"]
    del d["ls_id"]
    del d["base_uri"]
    del d["owning_client"]
    return d


class StudentCollection(ResourceCollection):
  uri_resource_name = "student"
  collection_name = "students"
  instance_class = Student
  pagesize = 2000
