import unittest

from learnsprout.errors import LearnSproutClientException
from learnsprout.client import LearnSproutClient
from learnsprout.resources import Section
from learnsprout.tests import sample_org_id, sample_school_id

class TestSections(unittest.TestCase):
  """ Tests for Section resources.  """
  def setUp(self):
    """ Set up Section tests. """
    lsc = LearnSproutClient()
    self.org = lsc.orgs.get(sample_org_id)
    school = self.org.schools.get(sample_school_id)
    self.sections_resource = school.sections

  def ensure_members(self, section):
    """ Ensure a Section has the expected members. """
    self.assertTrue(hasattr(section, "students"))
    self.assertTrue(hasattr(section, "term"))
    self.assertTrue(hasattr(section, "room"))
    self.assertTrue(hasattr(section, "number"))
    self.assertTrue(hasattr(section, "course"))
    self.assertTrue(hasattr(section, "teacher"))
    self.assertTrue(hasattr(section, "school"))
    self.assertTrue(hasattr(section, "time_updated"))
    self.assertTrue(hasattr(section, "ls_id"))

  def test_list_sections_page(self):
    """ List a set of Sections. """
    sections = self.sections_resource.iter_all()
    self.assertEqual(sections.is_empty, False)
    for section in sections:
      self.ensure_members(section)

  def test_get_section_by_id(self):
    """ Get a section by id. """
    section = self.sections_resource.iter_all().next()
    id1 = section.ls_id

    section = self.sections_resource.get(id1)
    self.assertIsInstance(section, Section)
    self.ensure_members(section)
    self.assertEqual(section.ls_id, id1)

class TestSectionsOrgRoute(TestSections):
  """
    Tests for Section resources accessed via the organization routes.
  """
  def setUp(self):
    super(TestSectionsOrgRoute, self).setUp()
    self.sections_resource = self.org.sections

if __name__ == '__main__':
  unittest.main()

