import unittest

from learnsprout.errors import LearnSproutClientException
from learnsprout.client import LearnSproutClient
from learnsprout.resources import Teacher
from learnsprout.tests import sample_org_id, sample_school_id

class TestTeachers(unittest.TestCase):
  """
    Tests for Teacher resources.
  """
  def setUp(self):
    """ Set up for Teacher tests. """
    lsc = LearnSproutClient()
    self.org = lsc.orgs.get(sample_org_id)
    school = self.org.schools.get(sample_school_id)
    self.teachers_resource = school.teachers

  def ensure_members(self, teacher):
    """ Ensure that a Teacher has all expected properties. """
    self.assertTrue(hasattr(teacher, "first_name"))
    self.assertTrue(hasattr(teacher, "last_name"))
    self.assertTrue(hasattr(teacher, "middle_name"))
    self.assertTrue(hasattr(teacher, "address"))
    self.assertTrue(hasattr(teacher, "school"))
    self.assertTrue(hasattr(teacher, "number"))
    self.assertTrue(hasattr(teacher, "phone"))
    self.assertTrue(hasattr(teacher, "time_updated"))
    self.assertTrue(hasattr(teacher, "id"))
    self.assertTrue(hasattr(teacher, "email"))

  def test_list_teachers(self):
    """ List a set of Teachers. """
    teachers = self.teachers_resource.iter_all()
    self.assertEqual(teachers.is_empty, False)

  def test_get_teacher_by_id(self):
    """ Get an instance of a Teacher by id. """
    teacher = self.teachers_resource.iter_all().next()
    id1 = teacher.ls_id

    teacher = self.teachers_resource.get(id1)
    self.assertIsInstance(teacher, Teacher)
    self.assertEqual(teacher.ls_id, id1)

class TestTeachersOrgRoute(TestTeachers):
  """
    Tests for Teacher resources accessed via an organization.
  """
  def setUp(self):
    super(TestTeachersOrgRoute, self).setUp()
    self.teachers_resource = self.org.teachers

if __name__ == '__main__':
  unittest.main()

