import unittest

from learnsprout.errors import LearnSproutClientException
from learnsprout.client import LearnSproutClient
from learnsprout.resources import Enrollment
from learnsprout.tests import sample_org_id, sample_school_id

class TestEnrollment(unittest.TestCase):
  """ Tests for Enrollment resources.  """
  def setUp(self):
    """ Set up Enrollment tests. """
    lsc = LearnSproutClient()
    self.org = lsc.orgs.get(sample_org_id)
    school = self.org.schools.get(sample_school_id)
    self.enrollment_resource = school.enrollment

  def ensure_members(self, enrollment):
    """ Ensure a Enrollment has the expected members. """
    self.assertTrue(hasattr(enrollment, "ls_id"))
    self.assertTrue(hasattr(enrollment, "school"))
    self.assertTrue(hasattr(enrollment, "student"))
    self.assertTrue(hasattr(enrollment, "entry_date"))
    self.assertTrue(hasattr(enrollment, "exit_date"))
    self.assertTrue(hasattr(enrollment, "time_updated"))

  def ensure_member_types(self, a):
    self.assertIsInstance(a.time_updated, int)
    self.assertIsInstance(a.entry_date, basestring)
    self.assertIsInstance(a.exit_date, basestring)
    self.assertIsInstance(a.school, dict)
    self.assertIsInstance(a.student, dict)

  def test_has_members(self):
    """ Check a single enrollment record. """
    a = self.enrollment_resource.iter_all().next()
    self.assertIsInstance(a, Enrollment)
    self.ensure_members(a)
    self.ensure_member_types(a)

  def test_school_filter(self):
    enrollment = [e for e in self.enrollment_resource.iter_all()]
    schools = set()
    for rec in enrollment:
      schools.add(rec.school['id'])
    self.assertTrue(len(schools), 1)

class TestEnrollmentOrgRoute(TestEnrollment):
  """
    Tests for Enrollment resources accessed via the organization routes.
  """
  def setUp(self):
    super(TestEnrollmentOrgRoute, self).setUp()
    self.enrollment_resource = self.org.enrollment

if __name__ == '__main__':
  unittest.main()
