import os, unittest

from learnsprout import constants
from learnsprout.client import LearnSproutClient
from learnsprout.errors import LearnSproutException, LearnSproutClientException, MissingAPIConfig

class TestLearnSproutClient(unittest.TestCase):
  """ Test the LearnSproutClient itself, not the resources it manages. """

  def test_no_api_root_url(self):
    """ Creating a LearnSproutClient without an API root_url specified. """
    lsc = LearnSproutClient(api_root_url=None)
    self.assertEqual(lsc.api_root_url, "https://v1.api.learnsprout.com")

  def test_user_agent(self):
    lsc = LearnSproutClient()
    r = lsc.make_request(constants.default_root_url) # just the root url
    self.assertTrue('learnsprout' in lsc.last_response.request.headers['USER-AGENT'])

class TestLearnSproutClientWithoutEnv(unittest.TestCase):
  """ Test the LearnSproutClient without environment variables set. """

  def setUp(self):
    """ Set up LearnSproutClient tests with environment variables removed. """
    self.apikey = os.environ["LEARNSPROUT_APIKEY"]
    del os.environ["LEARNSPROUT_APIKEY"]

  def tearDown(self):
    """ Clean up LearnSproutClient tests by setting environment variables. """
    os.environ["LEARNSPROUT_APIKEY"] = self.apikey

  def test_no_api_key(self):
    """ Attempt to create a LearnSproutClient without an API key. """
    self.assertRaises(MissingAPIConfig, LearnSproutClient, apikey=None)

  def test_org_bad_api_key(self):
    """ Attempt to create a LearnSproutClient with a bad API key. """
    self.assertRaises(LearnSproutClient, apikey="i-am-a-bad-key-rah-rah")

if __name__ == '__main__':
  unittest.main()
